/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.oom.PackageStats;
import net.sourceforge.pmd.lang.java.oom.api.ClassMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.Metric;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;
import net.sourceforge.pmd.lang.java.oom.api.OperationMetricKey;
import net.sourceforge.pmd.lang.java.oom.api.ResultOption;

public final class Metrics {
    private static final PackageStats TOP_LEVEL_PACKAGE = new PackageStats();

    private Metrics() {
    }

    static PackageStats getTopLevelPackageStats() {
        return TOP_LEVEL_PACKAGE;
    }

    public static double get(ClassMetricKey key, ASTClassOrInterfaceDeclaration node) {
        return Metrics.get(key, node, (MetricVersion)Metric.Version.STANDARD);
    }

    public static double get(ClassMetricKey key, ASTClassOrInterfaceDeclaration node, MetricVersion version) {
        if (!key.getCalculator().supports(node)) {
            return Double.NaN;
        }
        MetricVersion safeVersion = version == null ? Metric.Version.STANDARD : version;
        return TOP_LEVEL_PACKAGE.compute(key, node, false, safeVersion);
    }

    public static double get(OperationMetricKey key, ASTMethodOrConstructorDeclaration node) {
        return Metrics.get(key, node, (MetricVersion)Metric.Version.STANDARD);
    }

    public static double get(OperationMetricKey key, ASTMethodOrConstructorDeclaration node, MetricVersion version) {
        if (!key.getCalculator().supports(node)) {
            return Double.NaN;
        }
        MetricVersion safeVersion = version == null ? Metric.Version.STANDARD : version;
        return TOP_LEVEL_PACKAGE.compute(key, node, false, safeVersion);
    }

    public static double get(OperationMetricKey key, ASTClassOrInterfaceDeclaration node, MetricVersion version, ResultOption option) {
        MetricVersion safeVersion = version == null ? Metric.Version.STANDARD : version;
        return option == null ? Double.NaN : TOP_LEVEL_PACKAGE.computeWithResultOption(key, node, false, safeVersion, option);
    }
}

