/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.oom.api.Metric;
import net.sourceforge.pmd.lang.java.oom.api.MetricKey;
import net.sourceforge.pmd.lang.java.oom.api.MetricVersion;

public final class ParameterizedMetricKey {
    private static final Map<Integer, ParameterizedMetricKey> POOL = new HashMap<Integer, ParameterizedMetricKey>();
    public final MetricKey<? extends Metric> key;
    public final MetricVersion version;

    private ParameterizedMetricKey(MetricKey<? extends Metric> key, MetricVersion version) {
        this.key = key;
        this.version = version;
    }

    public static ParameterizedMetricKey build(MetricKey<? extends Metric> key, MetricVersion version) {
        int code = ParameterizedMetricKey.code(key, version);
        ParameterizedMetricKey paramKey = POOL.get(code);
        if (paramKey == null) {
            POOL.put(code, new ParameterizedMetricKey(key, version));
        }
        return POOL.get(code);
    }

    private static int code(MetricKey key, MetricVersion version) {
        int result = key.hashCode();
        result = 31 * result + version.hashCode();
        return result;
    }

    public String toString() {
        return "ParameterizedMetricKey{key=" + this.key + ", version=" + this.version + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedMetricKey that = (ParameterizedMetricKey)o;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }
}

