/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom.signature;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.oom.signature.Signature;

public final class FieldSignature
extends Signature {
    private static final Map<Integer, FieldSignature> POOL = new HashMap<Integer, FieldSignature>();
    public final boolean isStatic;
    public final boolean isFinal;

    private FieldSignature(Signature.Visibility visibility, boolean isStatic, boolean isFinal) {
        super(visibility);
        this.isStatic = isStatic;
        this.isFinal = isFinal;
    }

    public static FieldSignature buildFor(ASTFieldDeclaration node) {
        int code = FieldSignature.code(Signature.Visibility.get(node), node.isStatic(), node.isFinal());
        if (!POOL.containsKey(code)) {
            POOL.put(code, new FieldSignature(Signature.Visibility.get(node), node.isStatic(), node.isFinal()));
        }
        return POOL.get(code);
    }

    private static int code(Signature.Visibility visibility, boolean isStatic, boolean isFinal) {
        return visibility.hashCode() * 31 + (isStatic ? 1 : 0) * 2 + (isFinal ? 1 : 0);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FieldSignature) {
            FieldSignature f = (FieldSignature)o;
            return super.equals(o) && f.isFinal == this.isFinal && f.isStatic == this.isStatic;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 16 + (this.isStatic ? 1 : 0) * 32 + (this.isFinal ? 1 : 0);
    }
}

