/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public final class ConstructorCallsOverridableMethodRule
extends AbstractJavaRule {
    private static final NullEvalPackage NULL_EVAL_PACKAGE = new NullEvalPackage();
    private final List<EvalPackage> evalPackages = new ArrayList<EvalPackage>();

    private static int compareNodes(Node n1, Node n2) {
        int l2;
        int l1 = n1.getBeginLine();
        if (l1 == (l2 = n2.getBeginLine())) {
            return n1.getBeginColumn() - n2.getBeginColumn();
        }
        return l1 - l2;
    }

    private EvalPackage getCurrentEvalPackage() {
        return this.evalPackages.get(this.evalPackages.size() - 1);
    }

    private void putEvalPackage(EvalPackage ep) {
        this.evalPackages.add(ep);
    }

    private void removeCurrentEvalPackage() {
        this.evalPackages.remove(this.evalPackages.size() - 1);
    }

    private void clearEvalPackages() {
        this.evalPackages.clear();
    }

    private Object visitClassDec(ASTClassOrInterfaceDeclaration node, Object data) {
        String className = node.getImage();
        if (!node.isFinal()) {
            this.putEvalPackage(new EvalPackage(className));
        } else {
            this.putEvalPackage(NULL_EVAL_PACKAGE);
        }
        super.visit(node, data);
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            while (this.evaluateDangerOfMethods(this.getCurrentEvalPackage().allMethodsOfClass)) {
            }
            this.evaluateDangerOfConstructors1(this.getCurrentEvalPackage().allPrivateConstructorsOfClass, this.getCurrentEvalPackage().allMethodsOfClass.keySet());
            while (this.evaluateDangerOfConstructors2(this.getCurrentEvalPackage().allPrivateConstructorsOfClass)) {
            }
            for (MethodInvocation meth : this.getCurrentEvalPackage().calledMethods) {
                for (MethodHolder h : this.getCurrentEvalPackage().allMethodsOfClass.keySet()) {
                    if (!h.isDangerous()) continue;
                    String methName = h.getASTMethodDeclarator().getImage();
                    int count = h.getASTMethodDeclarator().getParameterCount();
                    List<String> parameterTypes = ConstructorCallsOverridableMethodRule.getMethodDeclaratorParameterTypes((Node)h.getASTMethodDeclarator());
                    if (!methName.equals(meth.getName()) || meth.getArgumentCount() != count || !parameterTypes.equals(meth.getArgumentTypes())) continue;
                    this.addViolation(data, meth.getASTPrimaryExpression(), "method '" + h.getCalled() + "'");
                }
            }
            for (ConstructorHolder ch : this.getCurrentEvalPackage().allPrivateConstructorsOfClass.keySet()) {
                if (!ch.isDangerous()) continue;
                int paramCount = ch.getASTConstructorDeclaration().getParameterCount();
                for (ConstructorInvocation ci : this.getCurrentEvalPackage().calledConstructors) {
                    if (ci.getArgumentCount() != paramCount) continue;
                    this.addViolation(data, (Node)ci.getASTExplicitConstructorInvocation(), "constructor");
                }
            }
        }
        this.removeCurrentEvalPackage();
        return data;
    }

    private boolean evaluateDangerOfMethods(Map<MethodHolder, List<MethodInvocation>> classMethodMap) {
        boolean found = false;
        for (Map.Entry<MethodHolder, List<MethodInvocation>> entry : classMethodMap.entrySet()) {
            MethodHolder h = entry.getKey();
            List<MethodInvocation> calledMeths = entry.getValue();
            Iterator<MethodInvocation> calledMethsIter = calledMeths.iterator();
            block1: while (calledMethsIter.hasNext() && !h.isDangerous()) {
                MethodInvocation meth = calledMethsIter.next();
                for (MethodHolder h3 : classMethodMap.keySet()) {
                    if (!h3.isDangerous()) continue;
                    String matchMethodName = h3.getASTMethodDeclarator().getImage();
                    int matchMethodParamCount = h3.getASTMethodDeclarator().getParameterCount();
                    List<String> parameterTypes = ConstructorCallsOverridableMethodRule.getMethodDeclaratorParameterTypes((Node)h3.getASTMethodDeclarator());
                    if (!matchMethodName.equals(meth.getName()) || matchMethodParamCount != meth.getArgumentCount() || !parameterTypes.equals(meth.getArgumentTypes())) continue;
                    h.setDangerous();
                    h.setCalledMethod(matchMethodName);
                    found = true;
                    continue block1;
                }
            }
        }
        return found;
    }

    private void evaluateDangerOfConstructors1(Map<ConstructorHolder, List<MethodInvocation>> classConstructorMap, Set<MethodHolder> evaluatedMethods) {
        for (Map.Entry<ConstructorHolder, List<MethodInvocation>> entry : classConstructorMap.entrySet()) {
            ConstructorHolder ch = entry.getKey();
            if (ch.isDangerous()) continue;
            List<MethodInvocation> calledMeths = entry.getValue();
            Iterator<MethodInvocation> calledMethsIter = calledMeths.iterator();
            block1: while (calledMethsIter.hasNext() && !ch.isDangerous()) {
                MethodInvocation meth = calledMethsIter.next();
                String methName = meth.getName();
                int methArgCount = meth.getArgumentCount();
                for (MethodHolder h : evaluatedMethods) {
                    if (!h.isDangerous()) continue;
                    String matchName = h.getASTMethodDeclarator().getImage();
                    int matchParamCount = h.getASTMethodDeclarator().getParameterCount();
                    List<String> parameterTypes = ConstructorCallsOverridableMethodRule.getMethodDeclaratorParameterTypes((Node)h.getASTMethodDeclarator());
                    if (!methName.equals(matchName) || methArgCount != matchParamCount || !parameterTypes.equals(meth.getArgumentTypes())) continue;
                    ch.setDangerous(true);
                    continue block1;
                }
            }
        }
    }

    private boolean evaluateDangerOfConstructors2(Map<ConstructorHolder, List<MethodInvocation>> classConstructorMap) {
        boolean found = false;
        for (ConstructorHolder ch : classConstructorMap.keySet()) {
            ConstructorInvocation calledC = ch.getCalledConstructor();
            if (calledC == null || ch.isDangerous()) continue;
            int cCount = calledC.getArgumentCount();
            Iterator<ConstructorHolder> innerConstIter = classConstructorMap.keySet().iterator();
            while (innerConstIter.hasNext() && !ch.isDangerous()) {
                ConstructorHolder h2 = innerConstIter.next();
                if (!h2.isDangerous()) continue;
                int matchConstArgCount = h2.getASTConstructorDeclaration().getParameterCount();
                List<String> parameterTypes = ConstructorCallsOverridableMethodRule.getMethodDeclaratorParameterTypes(h2.getASTConstructorDeclaration());
                if (matchConstArgCount != cCount || !parameterTypes.equals(calledC.getArgumentTypes())) continue;
                ch.setDangerous(true);
                found = true;
            }
        }
        return found;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.clearEvalPackages();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (!node.isInterface()) {
            return this.visitClassDec(node, data);
        }
        this.putEvalPackage(NULL_EVAL_PACKAGE);
        Object o = super.visit(node, data);
        this.removeCurrentEvalPackage();
        return o;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            ArrayList<MethodInvocation> calledMethodsOfConstructor = new ArrayList<MethodInvocation>();
            ConstructorHolder ch = new ConstructorHolder(node);
            ConstructorCallsOverridableMethodRule.addCalledMethodsOfNode(node, calledMethodsOfConstructor, this.getCurrentEvalPackage().className);
            if (!node.isPrivate()) {
                this.getCurrentEvalPackage().calledMethods.addAll(calledMethodsOfConstructor);
                ASTExplicitConstructorInvocation eci = ch.getASTExplicitConstructorInvocation();
                if (eci != null && eci.isThis()) {
                    this.getCurrentEvalPackage().calledConstructors.add(ch.getCalledConstructor());
                }
            } else {
                this.getCurrentEvalPackage().allPrivateConstructorsOfClass.put(ch, calledMethodsOfConstructor);
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!(this.getCurrentEvalPackage() instanceof NullEvalPackage)) {
            AccessNode parent = (AccessNode)node.jjtGetParent();
            MethodHolder h = new MethodHolder(node);
            if (!(parent.isAbstract() || parent.isPrivate() || parent.isStatic() || parent.isFinal())) {
                h.setDangerous();
                ASTMethodDeclaration decl = (ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class);
                h.setCalledMethod(decl.getMethodName());
            }
            ArrayList<MethodInvocation> l = new ArrayList<MethodInvocation>();
            ConstructorCallsOverridableMethodRule.addCalledMethodsOfNode(parent, l, this.getCurrentEvalPackage().className);
            this.getCurrentEvalPackage().allMethodsOfClass.put(h, l);
        }
        return super.visit(node, data);
    }

    private static void addCalledMethodsOfNode(Node node, List<MethodInvocation> calledMethods, String className) {
        ArrayList<ASTPrimaryExpression> expressions = new ArrayList<ASTPrimaryExpression>();
        node.findDescendantsOfType(ASTPrimaryExpression.class, expressions, !(node instanceof AccessNode));
        ConstructorCallsOverridableMethodRule.addCalledMethodsOfNodeImpl(expressions, calledMethods, className);
    }

    private static void addCalledMethodsOfNodeImpl(List<ASTPrimaryExpression> expressions, List<MethodInvocation> calledMethods, String className) {
        for (ASTPrimaryExpression ape : expressions) {
            MethodInvocation meth = ConstructorCallsOverridableMethodRule.findMethod(ape, className);
            if (meth == null) continue;
            calledMethods.add(meth);
        }
    }

    private static MethodInvocation findMethod(ASTPrimaryExpression node, String className) {
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0).jjtGetNumChildren() > 0 && node.jjtGetChild(0).jjtGetChild(0) instanceof ASTLiteral) {
            return null;
        }
        MethodInvocation meth = MethodInvocation.getMethod(node);
        boolean found = false;
        if (meth != null && meth.getReferenceNames().isEmpty() && !meth.isSuper()) {
            List<String> packClass = meth.getQualifierNames();
            if (!packClass.isEmpty()) {
                for (String name : packClass) {
                    if (!name.equals(className)) continue;
                    found = true;
                    break;
                }
            } else {
                found = true;
            }
        }
        return found ? meth : null;
    }

    private static String getNameFromPrefix(ASTPrimaryPrefix node) {
        Node nnode;
        String name = null;
        if (node.jjtGetNumChildren() == 1 && (nnode = node.jjtGetChild(0)) instanceof ASTName) {
            name = ((ASTName)nnode).getImage();
        }
        return name;
    }

    private static List<String> getMethodDeclaratorParameterTypes(Node methodOrConstructorDeclarator) {
        List parameters = methodOrConstructorDeclarator.findDescendantsOfType(ASTFormalParameter.class);
        ArrayList<String> parameterTypes = new ArrayList<String>();
        if (parameters != null) {
            for (ASTFormalParameter p : parameters) {
                ASTType type = (ASTType)p.getFirstChildOfType(ASTType.class);
                if (type.jjtGetChild(0) instanceof ASTPrimitiveType) {
                    parameterTypes.add(type.jjtGetChild(0).getImage());
                    continue;
                }
                if (type.jjtGetChild(0) instanceof ASTReferenceType) {
                    parameterTypes.add("ref");
                    continue;
                }
                parameterTypes.add("<unkown>");
            }
        }
        return parameterTypes;
    }

    private static List<String> getArgumentTypes(ASTArguments args) {
        ArrayList<String> argumentTypes = new ArrayList<String>();
        ASTArgumentList argumentList = (ASTArgumentList)args.getFirstChildOfType(ASTArgumentList.class);
        if (argumentList != null) {
            for (int a = 0; a < argumentList.jjtGetNumChildren(); ++a) {
                Node expression = argumentList.jjtGetChild(a);
                ASTPrimaryPrefix arg = (ASTPrimaryPrefix)expression.getFirstDescendantOfType(ASTPrimaryPrefix.class);
                String type = "<unknown>";
                if (arg != null && arg.jjtGetNumChildren() > 0) {
                    if (arg.jjtGetChild(0) instanceof ASTLiteral) {
                        ASTLiteral lit = (ASTLiteral)arg.jjtGetChild(0);
                        if (lit.isCharLiteral()) {
                            type = "char";
                        } else if (lit.isFloatLiteral()) {
                            type = "float";
                        } else if (lit.isIntLiteral()) {
                            type = "int";
                        } else if (lit.isStringLiteral()) {
                            type = "String";
                        } else if (lit.jjtGetNumChildren() > 0 && lit.jjtGetChild(0) instanceof ASTBooleanLiteral) {
                            type = "boolean";
                        } else if (lit.isDoubleLiteral()) {
                            type = "double";
                        } else if (lit.isLongLiteral()) {
                            type = "long";
                        }
                    } else if (arg.jjtGetChild(0) instanceof ASTName) {
                        type = "ref";
                    }
                }
                argumentTypes.add(type);
            }
        }
        return argumentTypes;
    }

    private static final class NullEvalPackage
    extends EvalPackage {
        NullEvalPackage() {
            this.className = "";
            this.calledMethods = Collections.emptyList();
            this.allMethodsOfClass = Collections.emptyMap();
            this.calledConstructors = Collections.emptyList();
            this.allPrivateConstructorsOfClass = Collections.emptyMap();
        }
    }

    private static class EvalPackage {
        public String className;
        public List<MethodInvocation> calledMethods;
        public Map<MethodHolder, List<MethodInvocation>> allMethodsOfClass;
        public List<ConstructorInvocation> calledConstructors;
        public Map<ConstructorHolder, List<MethodInvocation>> allPrivateConstructorsOfClass;

        EvalPackage() {
        }

        EvalPackage(String className) {
            this.className = className;
            this.calledMethods = new ArrayList<MethodInvocation>();
            this.allMethodsOfClass = new TreeMap<MethodHolder, List<MethodInvocation>>(new MethodHolderComparator());
            this.calledConstructors = new ArrayList<ConstructorInvocation>();
            this.allPrivateConstructorsOfClass = new TreeMap<ConstructorHolder, List<MethodInvocation>>(new ConstructorHolderComparator());
        }
    }

    private static class ConstructorHolderComparator
    implements Comparator<ConstructorHolder> {
        private ConstructorHolderComparator() {
        }

        @Override
        public int compare(ConstructorHolder o1, ConstructorHolder o2) {
            return ConstructorCallsOverridableMethodRule.compareNodes(o1.getASTConstructorDeclaration(), o2.getASTConstructorDeclaration());
        }
    }

    private static class MethodHolderComparator
    implements Comparator<MethodHolder> {
        private MethodHolderComparator() {
        }

        @Override
        public int compare(MethodHolder o1, MethodHolder o2) {
            return ConstructorCallsOverridableMethodRule.compareNodes((Node)o1.getASTMethodDeclarator(), (Node)o2.getASTMethodDeclarator());
        }
    }

    private static final class ConstructorHolder {
        private ASTConstructorDeclaration cd;
        private boolean dangerous;
        private ConstructorInvocation ci;
        private boolean ciInitialized;

        ConstructorHolder(ASTConstructorDeclaration cd) {
            this.cd = cd;
        }

        public ASTConstructorDeclaration getASTConstructorDeclaration() {
            return this.cd;
        }

        public ConstructorInvocation getCalledConstructor() {
            if (!this.ciInitialized) {
                this.initCI();
            }
            return this.ci;
        }

        public ASTExplicitConstructorInvocation getASTExplicitConstructorInvocation() {
            ASTExplicitConstructorInvocation eci = null;
            if (!this.ciInitialized) {
                this.initCI();
            }
            if (this.ci != null) {
                eci = this.ci.getASTExplicitConstructorInvocation();
            }
            return eci;
        }

        private void initCI() {
            List expressions = this.cd.findChildrenOfType(ASTExplicitConstructorInvocation.class);
            if (!expressions.isEmpty()) {
                ASTExplicitConstructorInvocation eci = (ASTExplicitConstructorInvocation)expressions.get(0);
                this.ci = new ConstructorInvocation(eci);
            }
            this.ciInitialized = true;
        }

        public boolean isDangerous() {
            return this.dangerous;
        }

        public void setDangerous(boolean dangerous) {
            this.dangerous = dangerous;
        }
    }

    private static final class MethodHolder {
        private ASTMethodDeclarator amd;
        private boolean dangerous;
        private String called;

        MethodHolder(ASTMethodDeclarator amd) {
            this.amd = amd;
        }

        public void setCalledMethod(String name) {
            this.called = name;
        }

        public String getCalled() {
            return this.called;
        }

        public ASTMethodDeclarator getASTMethodDeclarator() {
            return this.amd;
        }

        public boolean isDangerous() {
            return this.dangerous;
        }

        public void setDangerous() {
            this.dangerous = true;
        }
    }

    private static final class ConstructorInvocation {
        private ASTExplicitConstructorInvocation eci;
        private String name;
        private int count = 0;
        private List<String> argumentTypes = new ArrayList<String>();

        ConstructorInvocation(ASTExplicitConstructorInvocation eci) {
            this.eci = eci;
            List l = eci.findChildrenOfType(ASTArguments.class);
            if (!l.isEmpty()) {
                ASTArguments aa = (ASTArguments)l.get(0);
                this.count = aa.getArgumentCount();
                this.argumentTypes = ConstructorCallsOverridableMethodRule.getArgumentTypes(aa);
            }
            this.name = eci.getImage();
        }

        public ASTExplicitConstructorInvocation getASTExplicitConstructorInvocation() {
            return this.eci;
        }

        public int getArgumentCount() {
            return this.count;
        }

        public List<String> getArgumentTypes() {
            return this.argumentTypes;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class MethodInvocation {
        private String name;
        private ASTPrimaryExpression ape;
        private List<String> referenceNames;
        private List<String> qualifierNames;
        private int argumentSize;
        private List<String> argumentTypes;
        private boolean superCall;

        private MethodInvocation(ASTPrimaryExpression ape, List<String> qualifierNames, List<String> referenceNames, String name, int argumentSize, List<String> argumentTypes, boolean superCall) {
            this.ape = ape;
            this.qualifierNames = qualifierNames;
            this.referenceNames = referenceNames;
            this.name = name;
            this.argumentSize = argumentSize;
            this.argumentTypes = argumentTypes;
            this.superCall = superCall;
        }

        public boolean isSuper() {
            return this.superCall;
        }

        public String getName() {
            return this.name;
        }

        public int getArgumentCount() {
            return this.argumentSize;
        }

        public List<String> getArgumentTypes() {
            return this.argumentTypes;
        }

        public List<String> getReferenceNames() {
            return this.referenceNames;
        }

        public List<String> getQualifierNames() {
            return this.qualifierNames;
        }

        public ASTPrimaryExpression getASTPrimaryExpression() {
            return this.ape;
        }

        public static MethodInvocation getMethod(ASTPrimaryExpression node) {
            Node lastNode;
            MethodInvocation meth = null;
            int i = node.jjtGetNumChildren();
            if (i > 1 && (lastNode = node.jjtGetChild(i - 1)).jjtGetNumChildren() == 1 && lastNode.jjtGetChild(0) instanceof ASTArguments) {
                String name;
                StringTokenizer st;
                String toParse;
                Node child;
                int x;
                ArrayList<String> varNames = new ArrayList<String>();
                ArrayList<String> packagesAndClasses = new ArrayList<String>();
                String methodName = null;
                ASTArguments args = (ASTArguments)lastNode.jjtGetChild(0);
                int numOfArguments = args.getArgumentCount();
                List argumentTypes = ConstructorCallsOverridableMethodRule.getArgumentTypes(args);
                boolean superFirst = false;
                int thisIndex = -1;
                for (x = 0; x < i - 1; ++x) {
                    AbstractJavaTypeNode child2;
                    child = node.jjtGetChild(x);
                    if (child instanceof ASTPrimarySuffix) {
                        child2 = (ASTPrimarySuffix)child;
                        if (child2.getImage() != null || child2.jjtGetNumChildren() != 0) continue;
                        thisIndex = x;
                        break;
                    }
                    if (!(child instanceof ASTPrimaryPrefix) || ConstructorCallsOverridableMethodRule.getNameFromPrefix((ASTPrimaryPrefix)(child2 = (ASTPrimaryPrefix)child)) != null) continue;
                    if (child2.getImage() == null) {
                        thisIndex = x;
                        break;
                    }
                    superFirst = true;
                    thisIndex = x;
                    break;
                }
                if (thisIndex != -1) {
                    if (superFirst) {
                        ASTPrimaryPrefix child2 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                        String name2 = child2.getImage();
                        if (i == 2) {
                            methodName = name2;
                        } else {
                            varNames.add(name2);
                        }
                        for (int x2 = 1; x2 < i - 1; ++x2) {
                            child = node.jjtGetChild(x2);
                            ASTPrimarySuffix ps = (ASTPrimarySuffix)child;
                            if (ps.isArguments()) continue;
                            String name3 = ((ASTPrimarySuffix)child).getImage();
                            if (x2 == i - 2) {
                                methodName = name3;
                                continue;
                            }
                            varNames.add(name3);
                        }
                    } else {
                        if (thisIndex == 1) {
                            ASTPrimaryPrefix child3 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                            toParse = ConstructorCallsOverridableMethodRule.getNameFromPrefix(child3);
                            st = new StringTokenizer(toParse, ".");
                            while (st.hasMoreTokens()) {
                                packagesAndClasses.add(st.nextToken());
                            }
                        }
                        for (x = thisIndex + 1; x < i - 1; ++x) {
                            child = (ASTPrimarySuffix)node.jjtGetChild(x);
                            if (child.isArguments()) continue;
                            name = child.getImage();
                            if (x == i - 2) {
                                methodName = name;
                                continue;
                            }
                            varNames.add(name);
                        }
                    }
                } else {
                    ASTPrimaryPrefix child4 = (ASTPrimaryPrefix)node.jjtGetChild(0);
                    toParse = ConstructorCallsOverridableMethodRule.getNameFromPrefix(child4);
                    st = new StringTokenizer(toParse, ".");
                    while (st.hasMoreTokens()) {
                        String value = st.nextToken();
                        if (!st.hasMoreTokens()) {
                            if (i == 2) {
                                methodName = value;
                                continue;
                            }
                            varNames.add(value);
                            continue;
                        }
                        varNames.add(value);
                    }
                    for (int x3 = 1; x3 < i - 1; ++x3) {
                        child = (ASTPrimarySuffix)node.jjtGetChild(x3);
                        if (child.isArguments()) continue;
                        name = child.getImage();
                        if (x3 == i - 2) {
                            methodName = name;
                            continue;
                        }
                        varNames.add(name);
                    }
                }
                meth = new MethodInvocation(node, packagesAndClasses, varNames, methodName, numOfArguments, argumentTypes, superFirst);
            }
            return meth;
        }

        public void show() {
            System.out.println("<MethodInvocation>");
            System.out.println("  <Qualifiers>");
            for (String name : this.getQualifierNames()) {
                System.out.println("    " + name);
            }
            System.out.println("  </Qualifiers>");
            System.out.println("  <Super>" + this.isSuper() + "</Super>");
            System.out.println("  <References>");
            for (String name : this.getReferenceNames()) {
                System.out.println("    " + name);
            }
            System.out.println("  </References>");
            System.out.println("  <Name>" + this.getName() + "</Name>");
            System.out.println("  <ArgumentCount>" + this.getArgumentCount() + "</ArgumentCount>");
            System.out.println("  <ArgumentTypes>" + this.getArgumentTypes() + "</ArgumentTypes>");
            System.out.println("</MethodInvocation>");
        }
    }
}

