/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.typedefinition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.JavaTypeDefinitionBuilder;
import net.sourceforge.pmd.lang.java.typeresolution.typedefinition.TypeDefinition;

public class JavaTypeDefinition
implements TypeDefinition {
    private final Class<?> clazz;
    private List<JavaTypeDefinition> genericArgs;
    private static Map<Class<?>, JavaTypeDefinition> onlyClassTypeDef = new HashMap();

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    public List<JavaTypeDefinition> getGenericArgs() {
        if (this.genericArgs == null) {
            this.genericArgs = Collections.unmodifiableList(new ArrayList());
        }
        return this.genericArgs;
    }

    private JavaTypeDefinition(Class<?> clazz, List<JavaTypeDefinition> genericArgs) {
        this.clazz = clazz;
        if (genericArgs != null) {
            this.genericArgs = Collections.unmodifiableList(genericArgs);
        }
    }

    public static JavaTypeDefinition build(Class<?> clazz) {
        if (onlyClassTypeDef.containsKey(clazz)) {
            return onlyClassTypeDef.get(clazz);
        }
        JavaTypeDefinition typeDef = new JavaTypeDefinition(clazz, null);
        onlyClassTypeDef.put(clazz, typeDef);
        return typeDef;
    }

    static JavaTypeDefinition build(Class<?> clazz, List<JavaTypeDefinition> genericArgs) {
        if (genericArgs == null) {
            return JavaTypeDefinition.build(clazz);
        }
        return new JavaTypeDefinition(clazz, genericArgs);
    }

    public static JavaTypeDefinitionBuilder builder(Class<?> clazz) {
        return new JavaTypeDefinitionBuilder().setType(clazz);
    }

    public static JavaTypeDefinitionBuilder builder() {
        return new JavaTypeDefinitionBuilder();
    }
}

