/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class AssignmentInOperandRule
extends AbstractJavaRule {
    private static final BooleanProperty ALLOW_IF_DESCRIPTOR = new BooleanProperty("allowIf", "Allow assignment within the conditional expression of an if statement", false, 1.0f);
    private static final BooleanProperty ALLOW_FOR_DESCRIPTOR = new BooleanProperty("allowFor", "Allow assignment within the conditional expression of a for statement", false, 2.0f);
    private static final BooleanProperty ALLOW_WHILE_DESCRIPTOR = new BooleanProperty("allowWhile", "Allow assignment within the conditional expression of a while statement", false, 3.0f);
    private static final BooleanProperty ALLOW_INCREMENT_DECREMENT_DESCRIPTOR = new BooleanProperty("allowIncrementDecrement", "Allow increment or decrement operators within the conditional expression of an if, for, or while statement", false, 4.0f);

    public AssignmentInOperandRule() {
        this.definePropertyDescriptor((PropertyDescriptor)ALLOW_IF_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)ALLOW_FOR_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)ALLOW_WHILE_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)ALLOW_INCREMENT_DECREMENT_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTExpression node, Object data) {
        Node parent = node.jjtGetParent();
        if ((parent instanceof ASTIfStatement && (Boolean)this.getProperty((PropertyDescriptor)ALLOW_IF_DESCRIPTOR) == false || parent instanceof ASTWhileStatement && (Boolean)this.getProperty((PropertyDescriptor)ALLOW_WHILE_DESCRIPTOR) == false || parent instanceof ASTForStatement && parent.jjtGetChild(1) == node && !((Boolean)this.getProperty((PropertyDescriptor)ALLOW_FOR_DESCRIPTOR)).booleanValue()) && (node.hasDescendantOfType(ASTAssignmentOperator.class) || !((Boolean)this.getProperty((PropertyDescriptor)ALLOW_INCREMENT_DECREMENT_DESCRIPTOR)).booleanValue() && node.hasDecendantOfAnyType(new Class[]{ASTPreIncrementExpression.class, ASTPreDecrementExpression.class, ASTPostfixExpression.class}))) {
            this.addViolation(data, node);
            return data;
        }
        return super.visit(node, data);
    }

    public boolean allowsAllAssignments() {
        return (Boolean)this.getProperty((PropertyDescriptor)ALLOW_IF_DESCRIPTOR) != false && (Boolean)this.getProperty((PropertyDescriptor)ALLOW_FOR_DESCRIPTOR) != false && (Boolean)this.getProperty((PropertyDescriptor)ALLOW_WHILE_DESCRIPTOR) != false && (Boolean)this.getProperty((PropertyDescriptor)ALLOW_INCREMENT_DECREMENT_DESCRIPTOR) != false;
    }

    public String dysfunctionReason() {
        return this.allowsAllAssignments() ? "All assignment types allowed, no checks performed" : null;
    }
}

