/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaParserDecoratedVisitor;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaClassMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaOperationMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.visitors.NcssBaseVisitor;
import net.sourceforge.pmd.lang.java.metrics.impl.visitors.NcssCountImportsDecorator;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public final class NcssMetric {

    public static final class NcssOperationMetric
    extends AbstractJavaOperationMetric {
        @Override
        public boolean supports(ASTMethodOrConstructorDeclaration node) {
            return true;
        }

        public double computeFor(ASTMethodOrConstructorDeclaration node, MetricOptions version) {
            Set options = version.getOptions();
            JavaParserDecoratedVisitor visitor = new JavaParserDecoratedVisitor(NcssBaseVisitor.INSTANCE);
            if (options.contains((Object)NcssOption.COUNT_IMPORTS)) {
                visitor.decorateWith(new NcssCountImportsDecorator());
            }
            MutableInt ncss = (MutableInt)node.jjtAccept(visitor, new MutableInt(0));
            return ncss.getValue().intValue();
        }
    }

    public static final class NcssClassMetric
    extends AbstractJavaClassMetric {
        @Override
        public boolean supports(ASTAnyTypeDeclaration node) {
            return true;
        }

        public double computeFor(ASTAnyTypeDeclaration node, MetricOptions version) {
            Set options = version.getOptions();
            JavaParserDecoratedVisitor visitor = new JavaParserDecoratedVisitor(NcssBaseVisitor.INSTANCE);
            if (options.contains((Object)NcssOption.COUNT_IMPORTS)) {
                visitor.decorateWith(new NcssCountImportsDecorator());
            }
            MutableInt ncss = (MutableInt)node.jjtAccept(visitor, new MutableInt(0));
            return ncss.getValue().intValue();
        }
    }

    public static enum NcssOption implements MetricOption
    {
        COUNT_IMPORTS("countImports");

        private final String vName;

        private NcssOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }
}

