/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.StringReader;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Properties;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.internal.JavaCCTokenizer;
import net.sourceforge.pmd.cpd.token.JavaCCTokenFilter;
import net.sourceforge.pmd.cpd.token.TokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.java.JavaTokenManager;
import net.sourceforge.pmd.lang.java.ast.Token;

public class JavaTokenizer
extends JavaCCTokenizer {
    public static final String CPD_START = "\"CPD-START\"";
    public static final String CPD_END = "\"CPD-END\"";
    private boolean ignoreAnnotations;
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;
    private ConstructorDetector constructorDetector;

    public void setProperties(Properties properties) {
        this.ignoreAnnotations = Boolean.parseBoolean(properties.getProperty("ignore_annotations", "false"));
        this.ignoreLiterals = Boolean.parseBoolean(properties.getProperty("ignore_literals", "false"));
        this.ignoreIdentifiers = Boolean.parseBoolean(properties.getProperty("ignore_identifiers", "false"));
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) throws IOException {
        this.constructorDetector = new ConstructorDetector(this.ignoreIdentifiers);
        super.tokenize(sourceCode, tokenEntries);
    }

    protected TokenManager getLexerForSource(SourceCode sourceCode) {
        StringBuilder stringBuilder = sourceCode.getCodeBuffer();
        return new JavaTokenManager(new StringReader(stringBuilder.toString()));
    }

    protected TokenFilter getTokenFilter(TokenManager tokenManager) {
        return new JavaTokenFilter(tokenManager, this.ignoreAnnotations);
    }

    protected TokenEntry processToken(Tokens tokenEntries, GenericToken currentToken, String fileName) {
        String image = currentToken.getImage();
        Token javaToken = (Token)currentToken;
        this.constructorDetector.restoreConstructorToken(tokenEntries, javaToken);
        if (this.ignoreLiterals && (javaToken.kind == 72 || javaToken.kind == 71 || javaToken.kind == 64 || javaToken.kind == 68)) {
            image = String.valueOf(javaToken.kind);
        }
        if (this.ignoreIdentifiers && javaToken.kind == 73) {
            image = String.valueOf(javaToken.kind);
        }
        this.constructorDetector.processToken(javaToken);
        return new TokenEntry(image, fileName, currentToken.getBeginLine());
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    private static class TypeDeclaration {
        int indentationLevel;
        String name;

        TypeDeclaration(int indentationLevel) {
            this.indentationLevel = indentationLevel;
        }
    }

    private static class ConstructorDetector {
        private boolean ignoreIdentifiers;
        private Deque<TypeDeclaration> classMembersIndentations;
        private int currentNestingLevel;
        private boolean storeNextIdentifier;
        private String prevIdentifier;

        ConstructorDetector(boolean ignoreIdentifiers) {
            this.ignoreIdentifiers = ignoreIdentifiers;
            this.currentNestingLevel = 0;
            this.classMembersIndentations = new LinkedList<TypeDeclaration>();
        }

        public void processToken(Token currentToken) {
            if (!this.ignoreIdentifiers) {
                return;
            }
            switch (currentToken.kind) {
                case 73: {
                    if ("enum".equals(currentToken.image)) {
                        this.pushTypeDeclaration();
                    } else if (this.storeNextIdentifier) {
                        this.classMembersIndentations.peek().name = currentToken.image;
                        this.storeNextIdentifier = false;
                    }
                    this.prevIdentifier = currentToken.image;
                    break;
                }
                case 19: {
                    this.pushTypeDeclaration();
                    break;
                }
                case 78: {
                    ++this.currentNestingLevel;
                    break;
                }
                case 79: {
                    if (!this.classMembersIndentations.isEmpty() && this.classMembersIndentations.peek().indentationLevel == this.currentNestingLevel) {
                        this.classMembersIndentations.pop();
                    }
                    --this.currentNestingLevel;
                    break;
                }
                default: {
                    if (!this.storeNextIdentifier) break;
                    this.classMembersIndentations.pop();
                    this.storeNextIdentifier = false;
                }
            }
        }

        private void pushTypeDeclaration() {
            TypeDeclaration cd = new TypeDeclaration(this.currentNestingLevel + 1);
            this.classMembersIndentations.push(cd);
            this.storeNextIdentifier = true;
        }

        public void restoreConstructorToken(Tokens tokenEntries, Token currentToken) {
            if (!this.ignoreIdentifiers) {
                return;
            }
            if (currentToken.kind == 76 && !this.classMembersIndentations.isEmpty() && this.classMembersIndentations.peek().name.equals(this.prevIdentifier)) {
                int lastTokenIndex = tokenEntries.size() - 1;
                TokenEntry lastToken = (TokenEntry)tokenEntries.getTokens().get(lastTokenIndex);
                lastToken.setImage(this.prevIdentifier);
            }
        }
    }

    private static class JavaTokenFilter
    extends JavaCCTokenFilter {
        private boolean isAnnotation = false;
        private boolean nextTokenEndsAnnotation = false;
        private int annotationStack = 0;
        private boolean discardingSemicolon = false;
        private boolean discardingKeywords = false;
        private boolean discardingSuppressing = false;
        private boolean discardingAnnotations = false;
        private boolean ignoreAnnotations = false;

        JavaTokenFilter(TokenManager tokenManager, boolean ignoreAnnotations) {
            super(tokenManager);
            this.ignoreAnnotations = ignoreAnnotations;
        }

        protected void analyzeToken(GenericToken currentToken) {
            this.detectAnnotations((Token)currentToken);
            this.skipSemicolon((Token)currentToken);
            this.skipPackageAndImport((Token)currentToken);
            this.skipAnnotationSuppression((Token)currentToken);
            if (this.ignoreAnnotations) {
                this.skipAnnotations();
            }
        }

        private void skipPackageAndImport(Token currentToken) {
            if (currentToken.kind == 43 || currentToken.kind == 35) {
                this.discardingKeywords = true;
            } else if (this.discardingKeywords && currentToken.kind == 82) {
                this.discardingKeywords = false;
            }
        }

        private void skipSemicolon(Token currentToken) {
            if (currentToken.kind == 82) {
                this.discardingSemicolon = true;
            } else if (this.discardingSemicolon && currentToken.kind != 82) {
                this.discardingSemicolon = false;
            }
        }

        private void skipAnnotationSuppression(Token currentToken) {
            if (this.isAnnotation) {
                if (!this.discardingSuppressing && currentToken.kind == 72 && JavaTokenizer.CPD_START.equals(currentToken.image)) {
                    this.discardingSuppressing = true;
                } else if (this.discardingSuppressing && currentToken.kind == 72 && JavaTokenizer.CPD_END.equals(currentToken.image)) {
                    this.discardingSuppressing = false;
                }
            }
        }

        private void skipAnnotations() {
            if (!this.discardingAnnotations && this.isAnnotation) {
                this.discardingAnnotations = true;
            } else if (this.discardingAnnotations && !this.isAnnotation) {
                this.discardingAnnotations = false;
            }
        }

        protected boolean isLanguageSpecificDiscarding() {
            return this.discardingSemicolon || this.discardingKeywords || this.discardingAnnotations || this.discardingSuppressing;
        }

        private void detectAnnotations(Token currentToken) {
            if (this.isAnnotation && this.nextTokenEndsAnnotation) {
                this.isAnnotation = false;
                this.nextTokenEndsAnnotation = false;
            }
            if (this.isAnnotation) {
                if (currentToken.kind == 76) {
                    ++this.annotationStack;
                } else if (currentToken.kind == 77) {
                    --this.annotationStack;
                    if (this.annotationStack == 0) {
                        this.nextTokenEndsAnnotation = true;
                    }
                } else if (this.annotationStack == 0 && currentToken.kind != 73 && currentToken.kind != 76) {
                    this.isAnnotation = false;
                }
            }
            if (currentToken.kind == 85) {
                this.isAnnotation = true;
            }
        }
    }
}

