/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;

public class ASTClassOrInterfaceType
extends AbstractJavaTypeNode {
    public ASTClassOrInterfaceType(int id) {
        super(id);
    }

    public ASTClassOrInterfaceType(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isReferenceToClassSameCompilationUnit() {
        ASTCompilationUnit root = (ASTCompilationUnit)this.getFirstParentOfType(ASTCompilationUnit.class);
        List classes = root.findDescendantsOfType(ASTClassOrInterfaceDeclaration.class);
        for (ASTClassOrInterfaceDeclaration c : classes) {
            if (!c.hasImageEqualTo(this.getImage())) continue;
            return true;
        }
        List enums = root.findDescendantsOfType(ASTEnumDeclaration.class);
        for (ASTEnumDeclaration e : enums) {
            if (!e.hasImageEqualTo(this.getImage())) continue;
            return true;
        }
        return false;
    }

    public boolean isAnonymousClass() {
        return this.jjtGetParent().getFirstChildOfType(ASTClassOrInterfaceBody.class) != null;
    }

    public boolean isArray() {
        Node p = this.jjtGetParent();
        if (p instanceof ASTReferenceType) {
            return ((ASTReferenceType)p).isArray();
        }
        return false;
    }

    public int getArrayDepth() {
        Node p = this.jjtGetParent();
        if (p instanceof ASTReferenceType) {
            return ((ASTReferenceType)p).getArrayDepth();
        }
        return 0;
    }
}

