/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaClassMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaOperationMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.internal.ClassFanOutVisitor;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public final class ClassFanOutMetric {

    public static final class ClassFanOutOperationMetric
    extends AbstractJavaOperationMetric {
        @Override
        public boolean supports(MethodLikeNode node) {
            return true;
        }

        public double computeFor(MethodLikeNode node, MetricOptions options) {
            MutableInt cfo;
            if (node.jjtGetParent() instanceof ASTClassOrInterfaceBodyDeclaration) {
                ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.jjtGetParent();
                cfo = (MutableInt)parent.jjtAccept(new ClassFanOutVisitor(options, node), new MutableInt(0));
            } else {
                cfo = (MutableInt)node.jjtAccept(new ClassFanOutVisitor(options, node), new MutableInt(0));
            }
            return cfo.getValue().intValue();
        }
    }

    public static final class ClassFanOutClassMetric
    extends AbstractJavaClassMetric {
        public double computeFor(ASTAnyTypeDeclaration node, MetricOptions options) {
            MutableInt cfo = (MutableInt)node.jjtAccept(new ClassFanOutVisitor(options, node), new MutableInt(0));
            return cfo.getValue().intValue();
        }
    }

    public static enum ClassFanOutOption implements MetricOption
    {
        INCLUDE_JAVA_LANG("includeJavaLang");

        private final String vName;

        private ClassFanOutOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }
}

