/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.rule.AbstractLombokAwareRule;

public class UseUtilityClassRule
extends AbstractLombokAwareRule {
    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Arrays.asList("lombok.experimental.UtilityClass");
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (this.hasIgnoredAnnotation(node)) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceBody decl, Object data) {
        Object result = super.visit(decl, data);
        if (decl.jjtGetParent() instanceof ASTClassOrInterfaceDeclaration) {
            ASTClassOrInterfaceDeclaration parent = (ASTClassOrInterfaceDeclaration)decl.jjtGetParent();
            if (parent.isAbstract() || parent.isInterface() || parent.getSuperClassTypeNode() != null) {
                return result;
            }
            if (this.hasLombokNoArgsConstructor(parent)) {
                return result;
            }
            int i = decl.jjtGetNumChildren();
            int methodCount = 0;
            boolean isOK = false;
            while (i > 0) {
                ASTResultType res;
                ASTClassOrInterfaceType c;
                Node p;
                if ((p = decl.jjtGetChild(--i)).jjtGetNumChildren() == 0) continue;
                Node n = this.skipAnnotations(p);
                if (n instanceof ASTFieldDeclaration) {
                    if (((ASTFieldDeclaration)n).isStatic()) continue;
                    isOK = true;
                    break;
                }
                if (n instanceof ASTConstructorDeclaration) {
                    if (!((ASTConstructorDeclaration)n).isPrivate()) continue;
                    isOK = true;
                    break;
                }
                if (!(n instanceof ASTMethodDeclaration)) continue;
                ASTMethodDeclaration m = (ASTMethodDeclaration)n;
                if (!m.isPrivate()) {
                    ++methodCount;
                }
                if (!m.isStatic()) {
                    isOK = true;
                    break;
                }
                if (!m.getName().equals("suite") || (c = (ASTClassOrInterfaceType)(res = m.getResultType()).getFirstDescendantOfType(ASTClassOrInterfaceType.class)) == null || !c.hasImageEqualTo("Test")) continue;
                isOK = true;
                break;
            }
            if (!isOK && methodCount > 0) {
                this.addViolation(data, (Node)decl);
            }
        }
        return result;
    }

    private boolean hasLombokNoArgsConstructor(ASTClassOrInterfaceDeclaration parent) {
        ASTAnnotation annotation = parent.getAnnotation("lombok.NoArgsConstructor");
        if (annotation != null) {
            List memberValuePairs = annotation.findDescendantsOfType(ASTMemberValuePair.class);
            for (ASTMemberValuePair memberValuePair : memberValuePairs) {
                if (!"access".equals(memberValuePair.getImage())) continue;
                List names = memberValuePair.findDescendantsOfType(ASTName.class);
                for (ASTName name : names) {
                    if (!name.getImage().endsWith("PRIVATE")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Node skipAnnotations(Node p) {
        int index = 0;
        Node n = p.jjtGetChild(index++);
        while (n instanceof ASTAnnotation && index < p.jjtGetNumChildren()) {
            n = p.jjtGetChild(index++);
        }
        return n;
    }
}

