/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;

public abstract class AbstractJUnitRule
extends AbstractJavaRule {
    protected static final String JUNIT3_CLASS_NAME = "junit.framework.TestCase";
    protected static final String JUNIT4_CLASS_NAME = "org.junit.Test";
    protected static final String JUNIT5_CLASS_NAME = "org.junit.jupiter.api.Test";
    private boolean isJUnit3Class;
    private boolean isJUnit4Class;
    private boolean isJUnit5Class;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.isJUnit3Class = false;
        this.isJUnit4Class = false;
        this.isJUnit5Class = false;
        this.isJUnit3Class = this.isJUnit3Class(node);
        this.isJUnit4Class = this.isJUnit4Class(node);
        this.isJUnit5Class = this.isJUnit5Class(node);
        if (this.isJUnit4Class && this.isJUnit5Class) {
            this.isJUnit4Class &= this.hasImports(node, JUNIT4_CLASS_NAME);
            this.isJUnit5Class &= this.hasImports(node, JUNIT5_CLASS_NAME);
        }
        if (!this.isTestNgClass(node) && (this.isJUnit3Class || this.isJUnit4Class || this.isJUnit5Class)) {
            return super.visit(node, data);
        }
        return data;
    }

    private boolean isTestNgClass(ASTCompilationUnit node) {
        List imports = node.findDescendantsOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration i : imports) {
            if (i.getImportedName() == null || !i.getImportedName().startsWith("org.testng")) continue;
            return true;
        }
        return false;
    }

    public boolean isJUnitMethod(ASTMethodDeclaration method, Object data) {
        if (method.isAbstract() || method.isNative() || method.isStatic()) {
            return false;
        }
        if (!this.isJUnit5Class && !method.isPublic()) {
            return false;
        }
        boolean result = false;
        result |= this.isJUnit3Method(method);
        result |= this.isJUnit4Method(method);
        return result |= this.isJUnit5Method(method);
    }

    private boolean isJUnit4Method(ASTMethodDeclaration method) {
        return this.isJUnit4Class && this.doesNodeContainJUnitAnnotation(method.getParent(), JUNIT4_CLASS_NAME);
    }

    private boolean isJUnit5Method(ASTMethodDeclaration method) {
        return this.isJUnit5Class && this.doesNodeContainJUnitAnnotation(method.getParent(), JUNIT5_CLASS_NAME);
    }

    private boolean isJUnit3Method(ASTMethodDeclaration method) {
        return this.isJUnit3Class && method.isVoid() && method.getName().startsWith("test");
    }

    private boolean isJUnit3Class(ASTCompilationUnit node) {
        ASTClassOrInterfaceDeclaration cid = (ASTClassOrInterfaceDeclaration)node.getFirstDescendantOfType(ASTClassOrInterfaceDeclaration.class);
        if (cid == null) {
            return false;
        }
        if (node.getType() != null && TypeHelper.isA((TypeNode)node, JUNIT3_CLASS_NAME)) {
            return true;
        }
        if (node.getType() == null) {
            ASTExtendsList extendsList = (ASTExtendsList)cid.getFirstChildOfType(ASTExtendsList.class);
            if (extendsList == null) {
                return false;
            }
            if (((ASTClassOrInterfaceType)extendsList.getChild(0)).getImage().endsWith("TestCase")) {
                return true;
            }
            String className = cid.getImage();
            return className.endsWith("Test");
        }
        if (this.hasImports(node, JUNIT3_CLASS_NAME)) {
            return cid.getImage().endsWith("Test");
        }
        return false;
    }

    private boolean isJUnit4Class(ASTCompilationUnit node) {
        return this.doesNodeContainJUnitAnnotation((Node)node, JUNIT4_CLASS_NAME);
    }

    private boolean isJUnit5Class(ASTCompilationUnit node) {
        return this.doesNodeContainJUnitAnnotation((Node)node, JUNIT5_CLASS_NAME);
    }

    private boolean doesNodeContainJUnitAnnotation(Node node, String annotationTypeClassName) {
        List annotations = node.findDescendantsOfType(ASTAnnotation.class);
        for (ASTAnnotation annotation : annotations) {
            ASTName name;
            Node annotationTypeNode = annotation.getChild(0);
            TypeNode annotationType = (TypeNode)annotationTypeNode;
            if (!(annotationType.getType() == null ? (name = (ASTName)annotationTypeNode.getFirstChildOfType(ASTName.class)) != null && (name.hasImageEqualTo("Test") || name.hasImageEqualTo(annotationTypeClassName)) : TypeHelper.isA(annotationType, annotationTypeClassName))) continue;
            return true;
        }
        return false;
    }

    private boolean hasImports(ASTCompilationUnit cu, String className) {
        List imports = cu.findDescendantsOfType(ASTImportDeclaration.class);
        for (ASTImportDeclaration importDeclaration : imports) {
            ASTName name = (ASTName)importDeclaration.getFirstChildOfType(ASTName.class);
            if (name == null || !name.hasImageEqualTo(className)) continue;
            return true;
        }
        return false;
    }
}

