/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.performance.ConsecutiveLiteralAppendsRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class InefficientStringBufferingRule
extends AbstractJavaRule {
    public InefficientStringBufferingRule() {
        this.addRuleChainVisit(ASTAdditiveExpression.class);
    }

    @Override
    public Object visit(ASTAdditiveExpression node, Object data) {
        boolean onlyStringLiterals;
        if (node.getParent() instanceof ASTConditionalExpression || node.getNthParent(2) instanceof ASTConditionalExpression) {
            return data;
        }
        ASTBlockStatement bs = (ASTBlockStatement)node.getFirstParentOfType(ASTBlockStatement.class);
        if (bs == null) {
            return data;
        }
        int immediateLiterals = 0;
        int immediateStringLiterals = 0;
        List nodes = node.findDescendantsOfType(ASTLiteral.class);
        for (ASTLiteral literal : nodes) {
            if (literal.getNthParent(3) instanceof ASTAdditiveExpression) {
                ++immediateLiterals;
                if (literal.isStringLiteral()) {
                    ++immediateStringLiterals;
                }
            }
            if (!literal.isIntLiteral() && !literal.isFloatLiteral() && !literal.isDoubleLiteral() && !literal.isLongLiteral()) continue;
            return data;
        }
        boolean bl = onlyStringLiterals = immediateLiterals == immediateStringLiterals && immediateLiterals == node.getNumChildren();
        if (onlyStringLiterals) {
            return data;
        }
        List nameNodes = node.findDescendantsOfType(ASTName.class);
        for (Object name : nameNodes) {
            VariableNameDeclaration vnd;
            AccessNode accessNodeParent;
            if (((ASTName)name).getNameDeclaration() == null || !(((ASTName)name).getNameDeclaration() instanceof VariableNameDeclaration) || !(accessNodeParent = (vnd = (VariableNameDeclaration)((ASTName)name).getNameDeclaration()).getAccessNodeParent()).isFinal()) continue;
            return data;
        }
        boolean stringFound = false;
        for (ASTName name : nameNodes) {
            if (this.isPrimitiveType(name) || !this.isStringType(name)) continue;
            stringFound = true;
            break;
        }
        if (!stringFound && immediateStringLiterals == 0) {
            return data;
        }
        if (bs.isAllocation()) {
            ASTName name;
            Iterator iterator = nameNodes.iterator();
            while (iterator.hasNext() && (name = (ASTName)iterator.next()).getImage().endsWith("length")) {
                if (iterator.hasNext()) continue;
                return data;
            }
            if (this.isAllocatedStringBuffer(node)) {
                this.addViolation(data, (Node)node);
            } else if (InefficientStringBufferingRule.isInStringBufferOperationChain((Node)node, "append")) {
                this.addViolation(data, (Node)node);
            }
        } else if (InefficientStringBufferingRule.isInStringBufferOperationChain((Node)node, "append")) {
            this.addViolation(data, (Node)node);
        }
        return data;
    }

    private boolean isStringType(ASTName name) {
        List types;
        ASTType type = this.getTypeNode(name);
        if (type != null && !(types = type.findDescendantsOfType(ASTClassOrInterfaceType.class)).isEmpty()) {
            return TypeTestUtil.isA(String.class, (TypeNode)types.get(0));
        }
        return false;
    }

    private boolean isPrimitiveType(ASTName name) {
        ASTType type = this.getTypeNode(name);
        return type != null && !type.findChildrenOfType(ASTPrimitiveType.class).isEmpty();
    }

    private ASTType getTypeNode(ASTName name) {
        ASTType result = null;
        if (name.getNameDeclaration() instanceof VariableNameDeclaration) {
            VariableNameDeclaration vnd = (VariableNameDeclaration)name.getNameDeclaration();
            if (vnd.getAccessNodeParent() instanceof ASTLocalVariableDeclaration) {
                ASTLocalVariableDeclaration l = (ASTLocalVariableDeclaration)vnd.getAccessNodeParent();
                result = l.getTypeNode();
            } else if (vnd.getAccessNodeParent() instanceof ASTFormalParameter) {
                ASTFormalParameter p = (ASTFormalParameter)vnd.getAccessNodeParent();
                result = p.getTypeNode();
            }
        }
        return result;
    }

    static boolean isInStringBufferOperationChain(Node node, String methodName) {
        ASTPrimaryExpression expr;
        MethodCallChain methodCalls = MethodCallChain.wrap(expr);
        for (expr = (ASTPrimaryExpression)node.getFirstParentOfType(ASTPrimaryExpression.class); expr != null && methodCalls == null; expr = (ASTPrimaryExpression)expr.getFirstParentOfType(ASTPrimaryExpression.class)) {
            methodCalls = MethodCallChain.wrap(expr);
        }
        if (methodCalls != null && !methodCalls.isExactlyOfAnyType(StringBuffer.class, StringBuilder.class)) {
            methodCalls = null;
        }
        return methodCalls != null && methodCalls.getMethodNames().contains(methodName);
    }

    @Deprecated
    protected static boolean isInStringBufferOperation(Node node, int length, String methodName) {
        if (!(node.getNthParent(length) instanceof ASTStatementExpression)) {
            return false;
        }
        ASTStatementExpression s = (ASTStatementExpression)node.getFirstParentOfType(ASTStatementExpression.class);
        if (s == null) {
            return false;
        }
        ASTName n = (ASTName)s.getFirstDescendantOfType(ASTName.class);
        if (n == null || !n.getImage().contains(methodName) || !(n.getNameDeclaration() instanceof VariableNameDeclaration)) {
            return false;
        }
        ASTArgumentList argList = (ASTArgumentList)s.getFirstDescendantOfType(ASTArgumentList.class);
        if (argList == null || argList.getNumChildren() > 1) {
            return false;
        }
        return ConsecutiveLiteralAppendsRule.isStringBuilderOrBuffer(((VariableNameDeclaration)n.getNameDeclaration()).getDeclaratorId());
    }

    private boolean isAllocatedStringBuffer(ASTAdditiveExpression node) {
        ASTAllocationExpression ao = (ASTAllocationExpression)node.getFirstParentOfType(ASTAllocationExpression.class);
        if (ao == null) {
            return false;
        }
        ASTClassOrInterfaceType an = (ASTClassOrInterfaceType)ao.getFirstChildOfType(ASTClassOrInterfaceType.class);
        return ConsecutiveLiteralAppendsRule.isStringBuilderOrBuffer(an);
    }

    private static class MethodCallChain {
        private final ASTPrimaryExpression primary;

        private MethodCallChain(ASTPrimaryExpression primary) {
            this.primary = primary;
        }

        boolean isExactlyOfAnyType(Class<?> clazz, Class<?> ... clazzes) {
            ASTPrimaryPrefix typeNode = this.getTypeNode();
            if (TypeTestUtil.isExactlyA(clazz, (TypeNode)typeNode)) {
                return true;
            }
            if (clazzes != null) {
                for (Class<?> c : clazzes) {
                    if (!TypeTestUtil.isExactlyA(c, (TypeNode)typeNode)) continue;
                    return true;
                }
            }
            return false;
        }

        ASTPrimaryPrefix getTypeNode() {
            return (ASTPrimaryPrefix)this.primary.getFirstChildOfType(ASTPrimaryPrefix.class);
        }

        List<String> getMethodNames() {
            ArrayList<String> methodNames = new ArrayList<String>();
            ASTPrimaryPrefix prefix = this.getTypeNode();
            ASTName name = (ASTName)prefix.getFirstChildOfType(ASTName.class);
            if (name != null) {
                String firstMethod = name.getImage();
                int dot = firstMethod.lastIndexOf(46);
                if (dot != -1) {
                    firstMethod = firstMethod.substring(dot + 1);
                }
                methodNames.add(firstMethod);
            }
            for (ASTPrimarySuffix suffix : this.primary.findChildrenOfType(ASTPrimarySuffix.class)) {
                if (suffix.getImage() == null) continue;
                methodNames.add(suffix.getImage());
            }
            return methodNames;
        }

        static MethodCallChain wrap(ASTPrimaryExpression primary) {
            if (primary != null && MethodCallChain.isMethodCall(primary)) {
                return new MethodCallChain(primary);
            }
            return null;
        }

        private static boolean isMethodCall(ASTPrimaryExpression primary) {
            return primary.getNumChildren() >= 2 && primary.getChild(0) instanceof ASTPrimaryPrefix && primary.getChild(1) instanceof ASTPrimarySuffix;
        }
    }
}

