/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class UnusedPrivateMethodRule
extends AbstractIgnoredAnnotationRule {
    private static final Set<String> SERIALIZATION_METHODS = new HashSet<String>(Arrays.asList("readObject", "writeObject", "readResolve", "writeReplace"));

    public UnusedPrivateMethodRule() {
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Collections.singletonList("java.lang.Deprecated");
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        Map<MethodNameDeclaration, List<NameOccurrence>> methods = ((ClassScope)node.getScope().getEnclosingScope(ClassScope.class)).getMethodDeclarations();
        for (MethodNameDeclaration mnd : this.findUnique(methods)) {
            List<NameOccurrence> occs = methods.get((Object)mnd);
            if (!this.privateAndNotExcluded(mnd) || this.hasIgnoredAnnotation((Annotatable)mnd.getNode().getParent())) continue;
            if (occs.isEmpty()) {
                this.addViolation(data, (Node)mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
                continue;
            }
            if (!this.isMethodNotCalledFromOtherMethods(mnd, occs)) continue;
            this.addViolation(data, (Node)mnd.getNode(), mnd.getImage() + mnd.getParameterDisplaySignature());
        }
        return data;
    }

    private Set<MethodNameDeclaration> findUnique(Map<MethodNameDeclaration, List<NameOccurrence>> methods) {
        HashSet<MethodNameDeclaration> unique = new HashSet<MethodNameDeclaration>();
        HashSet<String> sigs = new HashSet<String>();
        for (MethodNameDeclaration mnd : methods.keySet()) {
            String sig = mnd.getImage() + mnd.getParameterCount() + mnd.isVarargs();
            if (!sigs.contains(sig)) {
                unique.add(mnd);
            }
            sigs.add(sig);
        }
        return unique;
    }

    private boolean isMethodNotCalledFromOtherMethods(MethodNameDeclaration mnd, List<NameOccurrence> occs) {
        int callsFromOutsideMethod = 0;
        for (NameOccurrence occ : occs) {
            ScopedNode occNode = occ.getLocation();
            ASTConstructorDeclaration enclosingConstructor = (ASTConstructorDeclaration)occNode.getFirstParentOfType(ASTConstructorDeclaration.class);
            if (enclosingConstructor != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTInitializer enclosingInitializer = (ASTInitializer)occNode.getFirstParentOfType(ASTInitializer.class);
            if (enclosingInitializer != null) {
                ++callsFromOutsideMethod;
                break;
            }
            ASTMethodDeclaration enclosingMethod = (ASTMethodDeclaration)occNode.getFirstParentOfType(ASTMethodDeclaration.class);
            if (enclosingMethod != null && mnd.getNode().getParent().equals(enclosingMethod)) continue;
            ++callsFromOutsideMethod;
            break;
        }
        return callsFromOutsideMethod == 0;
    }

    private boolean privateAndNotExcluded(MethodNameDeclaration mnd) {
        ASTMethodDeclaration node = mnd.getMethodNameDeclaratorNode().getParent();
        return node.isPrivate() && !SERIALIZATION_METHODS.contains(node.getName());
    }
}

