/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class AvoidUsingOctalValuesRule
extends AbstractJavaRule {
    public static final Pattern OCTAL_PATTERN = Pattern.compile("0[0-7]{2,}[lL]?");
    public static final Pattern STRICT_OCTAL_PATTERN = Pattern.compile("0[0-7]+[lL]?");
    private static final BooleanProperty STRICT_METHODS_DESCRIPTOR = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"strict").desc("Detect violations between 00 and 07")).defaultValue((Object)false)).uiOrder(1.0f)).build();

    public AvoidUsingOctalValuesRule() {
        this.definePropertyDescriptor((PropertyDescriptor)STRICT_METHODS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        boolean strict = (Boolean)this.getProperty((PropertyDescriptor)STRICT_METHODS_DESCRIPTOR);
        Pattern p = strict ? STRICT_OCTAL_PATTERN : OCTAL_PATTERN;
        String img = node.getImage();
        if (img != null && p.matcher(img).matches()) {
            this.addViolation(data, node);
        }
        return data;
    }
}

