/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.bestpractices.AbstractSunSecureRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class ArrayIsStoredDirectlyRule
extends AbstractSunSecureRule {
    private static final PropertyDescriptor<Boolean> ALLOW_PRIVATE = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowPrivate").defaultValue((Object)true)).desc("If true, allow private methods/constructors to store arrays directly")).build();

    public ArrayIsStoredDirectlyRule() {
        this.definePropertyDescriptor(ALLOW_PRIVATE);
        this.addRuleChainVisit(ASTConstructorDeclaration.class);
        this.addRuleChainVisit(ASTMethodDeclaration.class);
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.isPrivate() && ((Boolean)this.getProperty(ALLOW_PRIVATE)).booleanValue()) {
            return data;
        }
        ASTFormalParameter[] arrs = this.getArrays(node.getFormalParameters());
        List bs = node.findDescendantsOfType(ASTBlockStatement.class);
        this.checkAll(data, arrs, bs);
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isPrivate() && ((Boolean)this.getProperty(ALLOW_PRIVATE)).booleanValue()) {
            return data;
        }
        ASTFormalParameters params = (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class);
        ASTFormalParameter[] arrs = this.getArrays(params);
        this.checkAll(data, arrs, node.findDescendantsOfType(ASTBlockStatement.class));
        return data;
    }

    private void checkAll(Object context, ASTFormalParameter[] arrs, List<ASTBlockStatement> bs) {
        for (ASTFormalParameter element : arrs) {
            this.checkForDirectAssignment(context, element, bs);
        }
    }

    private String getExpressionVarName(Node e) {
        String assignedVar = this.getFirstNameImage(e);
        if (this.isMethodCall(e)) {
            return null;
        }
        if (assignedVar == null) {
            ASTPrimaryPrefix prefix = null;
            ASTPrimarySuffix suffix = null;
            if (e.getNumChildren() > 0 && e.getChild(0) instanceof ASTPrimaryExpression) {
                ASTPrimaryExpression primaryExpression = (ASTPrimaryExpression)e.getChild(0);
                prefix = (ASTPrimaryPrefix)primaryExpression.getChild(0);
                suffix = (ASTPrimarySuffix)primaryExpression.getFirstChildOfType(ASTPrimarySuffix.class);
            }
            if (suffix != null) {
                assignedVar = suffix.getImage();
                if (prefix != null) {
                    if (prefix.usesThisModifier()) {
                        assignedVar = "this." + assignedVar;
                    } else if (prefix.usesSuperModifier()) {
                        assignedVar = "super." + assignedVar;
                    }
                }
            }
        }
        return assignedVar;
    }

    private boolean isMethodCall(Node e) {
        ASTPrimaryExpression primaryExpression;
        if (e.getNumChildren() == 1 && e.getChild(0) instanceof ASTPrimaryExpression && (primaryExpression = (ASTPrimaryExpression)e.getChild(0)).getNumChildren() > 1) {
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)primaryExpression.getChild(1);
            return suffix.isArguments();
        }
        return false;
    }

    private void checkForDirectAssignment(Object ctx, ASTFormalParameter parameter, List<ASTBlockStatement> bs) {
        ASTVariableDeclaratorId vid = (ASTVariableDeclaratorId)parameter.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        String varName = vid.getName();
        for (ASTBlockStatement b : bs) {
            ASTPrimarySuffix foo;
            String val;
            ASTExpression e;
            ASTPrimaryExpression pe;
            Node n;
            String assignedVar;
            ASTStatementExpression se;
            if (!(b.getChild(0) instanceof ASTStatement) || !(((JavaNode)b.getChild(0)).getChild(0) instanceof ASTStatementExpression) || (se = (ASTStatementExpression)b.getFirstDescendantOfType(ASTStatementExpression.class)) == null || se.getNumChildren() < 2 || !(se.getChild(0) instanceof ASTPrimaryExpression) || !(se.getChild(1) instanceof ASTAssignmentOperator) || (assignedVar = this.getExpressionVarName((Node)se)) == null || (n = (Node)(pe = (ASTPrimaryExpression)se.getChild(0)).getFirstParentOfType(ASTMethodDeclaration.class)) == null && (n = (Node)pe.getFirstParentOfType(ASTConstructorDeclaration.class)) == null || this.isLocalVariable(assignedVar, n) || se.getNumChildren() < 3 || (e = (ASTExpression)se.getChild(2)).hasDescendantOfType(ASTEqualityExpression.class) || (val = this.getExpressionVarName((Node)e)) == null || (foo = (ASTPrimarySuffix)e.getFirstDescendantOfType(ASTPrimarySuffix.class)) != null && foo.isArrayDereference() || !val.equals(varName)) continue;
            Node md = (Node)parameter.getFirstParentOfType(ASTMethodDeclaration.class);
            if (md == null) {
                md = (Node)pe.getFirstParentOfType(ASTConstructorDeclaration.class);
            }
            if (this.isLocalVariable(varName, md)) continue;
            RuleContext ruleContext = (RuleContext)ctx;
            ruleContext.addViolation((Node)e, new Object[]{varName});
        }
    }

    private ASTFormalParameter[] getArrays(ASTFormalParameters params) {
        List l = params.findChildrenOfType(ASTFormalParameter.class);
        if (l != null && !l.isEmpty()) {
            ArrayList<ASTFormalParameter> l2 = new ArrayList<ASTFormalParameter>();
            for (ASTFormalParameter fp : l) {
                if (!fp.getVariableDeclaratorId().hasArrayType() && !fp.isVarargs()) continue;
                l2.add(fp);
            }
            return l2.toArray(new ASTFormalParameter[0]);
        }
        return new ASTFormalParameter[0];
    }
}

