/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;

public class MethodNamingConventionsRule
extends AbstractNamingConventionRule<ASTMethodDeclaration> {
    private static final Map<String, String> DESCRIPTOR_TO_DISPLAY_NAME = new HashMap<String, String>();
    @Deprecated
    private static final BooleanProperty CHECK_NATIVE_METHODS_DESCRIPTOR = new BooleanProperty("checkNativeMethods", "deprecated! Check native methods", true, 1.0f);
    private final RegexProperty instanceRegex = this.defaultProp("", "instance").build();
    private final RegexProperty staticRegex = this.defaultProp("static").build();
    private final RegexProperty nativeRegex = this.defaultProp("native").build();
    private final RegexProperty junit3Regex = this.defaultProp("JUnit 3 test").defaultValue("test[A-Z0-9][a-zA-Z0-9]*").build();
    private final RegexProperty junit4Regex = this.defaultProp("JUnit 4 test").build();

    public MethodNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)this.instanceRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.staticRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.nativeRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.junit3Regex);
        this.definePropertyDescriptor((PropertyDescriptor)this.junit4Regex);
    }

    private boolean isJunit4Test(ASTMethodDeclaration node) {
        return node.isAnnotationPresent("org.junit.Test");
    }

    private boolean isJunit3Test(ASTMethodDeclaration node) {
        if (!node.getMethodName().startsWith("test")) {
            return false;
        }
        Node parent = (Node)node.getFirstParentOfAnyType(new Class[]{ASTEnumConstant.class, ASTAllocationExpression.class, ASTAnyTypeDeclaration.class});
        if (!(parent instanceof ASTClassOrInterfaceDeclaration) || ((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            return false;
        }
        ASTClassOrInterfaceType superClass = ((ASTClassOrInterfaceDeclaration)parent).getSuperClassTypeNode();
        return superClass != null && TypeHelper.isA((TypeNode)superClass, "junit.framework.TestCase");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isAnnotationPresent("java.lang.Override")) {
            return super.visit(node, data);
        }
        if (node.isNative()) {
            if (!((Boolean)this.getProperty((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR)).booleanValue()) return super.visit(node, data);
            this.checkMatches(node, (PropertyDescriptor<Pattern>)this.nativeRegex, data);
            return super.visit(node, data);
        } else if (node.isStatic()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)this.staticRegex, data);
            return super.visit(node, data);
        } else if (this.isJunit4Test(node)) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)this.junit4Regex, data);
            return super.visit(node, data);
        } else if (this.isJunit3Test(node)) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)this.junit3Regex, data);
            return super.visit(node, data);
        } else {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)this.instanceRegex, data);
        }
        return super.visit(node, data);
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]+";
    }

    @Override
    String nameExtractor(ASTMethodDeclaration node) {
        return node.getMethodName();
    }

    @Override
    RegexProperty.RegexPBuilder defaultProp(String name, String displayName) {
        String display = (displayName + " method").trim();
        RegexProperty.RegexPBuilder prop = super.defaultProp(name.isEmpty() ? "method" : name, display);
        DESCRIPTOR_TO_DISPLAY_NAME.put(prop.getName(), display);
        return prop;
    }

    @Override
    String kindDisplayName(ASTMethodDeclaration node, PropertyDescriptor<Pattern> descriptor) {
        return DESCRIPTOR_TO_DISPLAY_NAME.get(descriptor.name());
    }
}

