/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.ImportWrapper;

public class DuplicateImportsRule
extends AbstractJavaRule {
    private Set<ImportWrapper> singleTypeImports;
    private Set<ImportWrapper> importOnDemandImports;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.singleTypeImports = new HashSet<ImportWrapper>();
        this.importOnDemandImports = new HashSet<ImportWrapper>();
        super.visit(node, data);
        for (ImportWrapper thisImportOnDemand : this.importOnDemandImports) {
            for (ImportWrapper thisSingleTypeImport : this.singleTypeImports) {
                String singleTypeFullName = thisSingleTypeImport.getName();
                int lastDot = singleTypeFullName.lastIndexOf(46);
                String singleTypePkg = singleTypeFullName.substring(0, lastDot);
                String singleTypeName = singleTypeFullName.substring(lastDot + 1);
                if (!thisImportOnDemand.getName().equals(singleTypePkg) || this.isDisambiguationImport(node, singleTypePkg, singleTypeName)) continue;
                this.addViolation(data, thisSingleTypeImport.getNode(), singleTypeFullName);
            }
        }
        this.singleTypeImports.clear();
        this.importOnDemandImports.clear();
        return data;
    }

    private boolean isDisambiguationImport(ASTCompilationUnit node, String singleTypePkg, String singleTypeName) {
        for (ImportWrapper thisImportOnDemand : this.importOnDemandImports) {
            if (thisImportOnDemand.getName().equals(singleTypePkg)) continue;
            if (!thisImportOnDemand.isStaticOnDemand()) {
                String fullyQualifiedClassName = thisImportOnDemand.getName() + "." + singleTypeName;
                if (!node.getClassTypeResolver().classNameExists(fullyQualifiedClassName)) continue;
                return true;
            }
            Class<?> importClass = node.getClassTypeResolver().loadClass(thisImportOnDemand.getName());
            if (importClass == null) continue;
            for (Method m : importClass.getMethods()) {
                if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(singleTypeName)) continue;
                return true;
            }
        }
        String fullyQualifiedClassName = "java.lang." + singleTypeName;
        return node.getClassTypeResolver().classNameExists(fullyQualifiedClassName);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ImportWrapper wrapper = new ImportWrapper(node.getImportedName(), node.getImportedName(), (Node)node.getImportedNameNode(), node.isStatic() && node.isImportOnDemand());
        if (node.isImportOnDemand()) {
            if (this.importOnDemandImports.contains(wrapper)) {
                this.addViolation(data, node.getImportedNameNode(), node.getImportedNameNode().getImage());
            } else {
                this.importOnDemandImports.add(wrapper);
            }
        } else if (this.singleTypeImports.contains(wrapper)) {
            this.addViolation(data, node.getImportedNameNode(), node.getImportedNameNode().getImage());
        } else {
            this.singleTypeImports.add(wrapper);
        }
        return data;
    }
}

