/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.Locale;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringMultiProperty;
import org.apache.commons.lang3.StringUtils;

public class LinguisticNamingRule
extends AbstractJavaRule {
    private static final BooleanProperty CHECK_BOOLEAN_METHODS = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkBooleanMethod").defaultValue((Object)true)).desc("Check method names and types for inconsistent naming.")).uiOrder(1.0f)).build();
    private static final BooleanProperty CHECK_GETTERS = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkGetters").defaultValue((Object)true)).desc("Check return type of getters.")).uiOrder(2.0f)).build();
    private static final BooleanProperty CHECK_SETTERS = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkSetters").defaultValue((Object)true)).desc("Check return type of setters.")).uiOrder(3.0f)).build();
    private static final BooleanProperty CHECK_PREFIXED_TRANSFORM_METHODS = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkPrefixedTransformMethods").defaultValue((Object)true)).desc("Check return type of methods whose names start with the configured prefix (see transformMethodNames property).")).uiOrder(4.0f)).build();
    private static final BooleanProperty CHECK_TRANSFORM_METHODS = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkTransformMethods").defaultValue((Object)false)).desc("Check return type of methods which contain the configured infix in their name (see transformMethodNames property).")).uiOrder(4.0f)).build();
    private static final StringMultiProperty BOOLEAN_METHOD_PREFIXES_PROPERTY = ((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)StringMultiProperty.named((String)"booleanMethodPrefixes").defaultValues((Object[])new String[]{"is", "has", "can", "have", "will", "should"})).desc("The prefixes of methods that return boolean.")).uiOrder(5.0f)).build();
    private static final StringMultiProperty TRANSFORM_METHOD_NAMES_PROPERTY = ((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)StringMultiProperty.named((String)"transformMethodNames").defaultValues((Object[])new String[]{"to", "as"})).desc("The prefixes and infixes that indicate a transform method.")).uiOrder(6.0f)).build();
    private static final BooleanProperty CHECK_FIELDS = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkFields").defaultValue((Object)true)).desc("Check field names and types for inconsistent naming.")).uiOrder(7.0f)).build();
    private static final BooleanProperty CHECK_VARIABLES = ((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)((BooleanProperty.BooleanPBuilder)BooleanProperty.named((String)"checkVariables").defaultValue((Object)true)).desc("Check local variable names and types for inconsistent naming.")).uiOrder(8.0f)).build();
    private static final StringMultiProperty BOOLEAN_FIELD_PREFIXES_PROPERTY = ((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)StringMultiProperty.named((String)"booleanFieldPrefixes").defaultValues((Object[])new String[]{"is", "has", "can", "have", "will", "should"})).desc("The prefixes of fields and variables that indicate boolean.")).uiOrder(9.0f)).build();

    public LinguisticNamingRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_BOOLEAN_METHODS);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_GETTERS);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_SETTERS);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_PREFIXED_TRANSFORM_METHODS);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_TRANSFORM_METHODS);
        this.definePropertyDescriptor((PropertyDescriptor)BOOLEAN_METHOD_PREFIXES_PROPERTY);
        this.definePropertyDescriptor((PropertyDescriptor)TRANSFORM_METHOD_NAMES_PROPERTY);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_FIELDS);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_VARIABLES);
        this.definePropertyDescriptor((PropertyDescriptor)BOOLEAN_FIELD_PREFIXES_PROPERTY);
        this.addRuleChainVisit(ASTMethodDeclaration.class);
        this.addRuleChainVisit(ASTFieldDeclaration.class);
        this.addRuleChainVisit(ASTLocalVariableDeclaration.class);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        String nameOfMethod = node.getMethodName();
        if (((Boolean)this.getProperty((PropertyDescriptor)CHECK_BOOLEAN_METHODS)).booleanValue()) {
            this.checkBooleanMethods(node, data, nameOfMethod);
        }
        if (((Boolean)this.getProperty((PropertyDescriptor)CHECK_SETTERS)).booleanValue()) {
            this.checkSetters(node, data, nameOfMethod);
        }
        if (((Boolean)this.getProperty((PropertyDescriptor)CHECK_GETTERS)).booleanValue()) {
            this.checkGetters(node, data, nameOfMethod);
        }
        if (((Boolean)this.getProperty((PropertyDescriptor)CHECK_PREFIXED_TRANSFORM_METHODS)).booleanValue()) {
            this.checkPrefixedTransformMethods(node, data, nameOfMethod);
        }
        if (((Boolean)this.getProperty((PropertyDescriptor)CHECK_TRANSFORM_METHODS)).booleanValue()) {
            this.checkTransformMethods(node, data, nameOfMethod);
        }
        return data;
    }

    private void checkPrefixedTransformMethods(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        ASTResultType resultType = node.getResultType();
        List prefixes = (List)this.getProperty((PropertyDescriptor)TRANSFORM_METHOD_NAMES_PROPERTY);
        String[] splitMethodName = StringUtils.splitByCharacterTypeCamelCase((String)nameOfMethod);
        if (resultType.isVoid() && splitMethodName.length > 0 && prefixes.contains(splitMethodName[0].toLowerCase(Locale.ROOT))) {
            this.addViolationWithMessage(data, node, "Linguistics Antipattern - The transform method ''{0}'' should not return void linguistically", new Object[]{nameOfMethod});
        }
    }

    private void checkTransformMethods(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        ASTResultType resultType = node.getResultType();
        List infixes = (List)this.getProperty((PropertyDescriptor)TRANSFORM_METHOD_NAMES_PROPERTY);
        for (String infix : infixes) {
            if (!resultType.isVoid() || !LinguisticNamingRule.containsWord(nameOfMethod, StringUtils.capitalize((String)infix))) continue;
            this.addViolationWithMessage(data, node, "Linguistics Antipattern - The transform method ''{0}'' should not return void linguistically", new Object[]{nameOfMethod});
            break;
        }
    }

    private void checkGetters(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        ASTResultType resultType = node.getResultType();
        if (LinguisticNamingRule.hasPrefix(nameOfMethod, "get") && resultType.isVoid()) {
            this.addViolationWithMessage(data, node, "Linguistics Antipattern - The getter ''{0}'' should not return void linguistically", new Object[]{nameOfMethod});
        }
    }

    private void checkSetters(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        ASTResultType resultType = node.getResultType();
        if (LinguisticNamingRule.hasPrefix(nameOfMethod, "set") && !resultType.isVoid()) {
            this.addViolationWithMessage(data, node, "Linguistics Antipattern - The setter ''{0}'' should not return any type except void linguistically", new Object[]{nameOfMethod});
        }
    }

    private void checkBooleanMethods(ASTMethodDeclaration node, Object data, String nameOfMethod) {
        ASTResultType resultType = node.getResultType();
        ASTType t = (ASTType)node.getResultType().getFirstChildOfType(ASTType.class);
        if (!resultType.isVoid() && t != null) {
            for (String prefix : (List)this.getProperty((PropertyDescriptor)BOOLEAN_METHOD_PREFIXES_PROPERTY)) {
                if (!LinguisticNamingRule.hasPrefix(nameOfMethod, prefix) || "boolean".equalsIgnoreCase(t.getTypeImage())) continue;
                this.addViolationWithMessage(data, node, "Linguistics Antipattern - The method ''{0}'' indicates linguistically it returns a boolean, but it returns ''{1}''", new Object[]{nameOfMethod, t.getTypeImage()});
            }
        }
    }

    private void checkField(String typeImage, ASTVariableDeclarator node, Object data) {
        for (String prefix : (List)this.getProperty((PropertyDescriptor)BOOLEAN_FIELD_PREFIXES_PROPERTY)) {
            if (!LinguisticNamingRule.hasPrefix(node.getName(), prefix) || "boolean".equalsIgnoreCase(typeImage)) continue;
            this.addViolationWithMessage(data, node, "Linguistics Antipattern - The field ''{0}'' indicates linguistically it is a boolean, but it is ''{1}''", new Object[]{node.getName(), typeImage});
        }
    }

    private void checkVariable(String typeImage, ASTVariableDeclarator node, Object data) {
        for (String prefix : (List)this.getProperty((PropertyDescriptor)BOOLEAN_FIELD_PREFIXES_PROPERTY)) {
            if (!LinguisticNamingRule.hasPrefix(node.getName(), prefix) || "boolean".equalsIgnoreCase(typeImage)) continue;
            this.addViolationWithMessage(data, node, "Linguistics Antipattern - The variable ''{0}'' indicates linguistically it is a boolean, but it is ''{1}''", new Object[]{node.getName(), typeImage});
        }
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        ASTType type = (ASTType)node.getFirstChildOfType(ASTType.class);
        if (type != null && ((Boolean)this.getProperty((PropertyDescriptor)CHECK_FIELDS)).booleanValue()) {
            List fields = node.findChildrenOfType(ASTVariableDeclarator.class);
            for (ASTVariableDeclarator field : fields) {
                this.checkField(type.getTypeImage(), field, data);
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        ASTType type = (ASTType)node.getFirstChildOfType(ASTType.class);
        if (type != null && ((Boolean)this.getProperty((PropertyDescriptor)CHECK_VARIABLES)).booleanValue()) {
            List variables = node.findChildrenOfType(ASTVariableDeclarator.class);
            for (ASTVariableDeclarator variable : variables) {
                this.checkVariable(type.getTypeImage(), variable, data);
            }
        }
        return data;
    }

    private static boolean hasPrefix(String name, String prefix) {
        return name.startsWith(prefix) && name.length() > prefix.length() && Character.isUpperCase(name.charAt(prefix.length()));
    }

    private static boolean containsWord(String name, String word) {
        int index = name.indexOf(word);
        if (index >= 0 && name.length() > index + word.length()) {
            return Character.isUpperCase(name.charAt(index + word.length()));
        }
        return false;
    }
}

