/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserDecoratedVisitor;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaOperationMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.visitors.CycloAssertAwareDecorator;
import net.sourceforge.pmd.lang.java.metrics.impl.visitors.CycloBaseVisitor;
import net.sourceforge.pmd.lang.java.metrics.impl.visitors.CycloPathAwareDecorator;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public final class CycloMetric
extends AbstractJavaOperationMetric {
    public double computeFor(final MethodLikeNode node, MetricOptions options) {
        Set opts = options.getOptions();
        JavaParserDecoratedVisitor visitor = new JavaParserDecoratedVisitor(CycloBaseVisitor.INSTANCE){

            @Override
            public Object visit(JavaNode localNode, Object data) {
                return localNode.isFindBoundary() && !localNode.equals(node) ? data : super.visit(localNode, data);
            }
        };
        if (opts.contains((Object)CycloOption.CONSIDER_ASSERT)) {
            visitor.decorateWith(new CycloAssertAwareDecorator());
        }
        if (!opts.contains((Object)CycloOption.IGNORE_BOOLEAN_PATHS)) {
            visitor.decorateWith(new CycloPathAwareDecorator());
        }
        MutableInt cyclo = (MutableInt)node.jjtAccept(visitor, new MutableInt(1));
        return cyclo.getValue().intValue();
    }

    public static int booleanExpressionComplexity(Node expr) {
        if (expr == null) {
            return 0;
        }
        List andNodes = expr.findDescendantsOfType(ASTConditionalAndExpression.class);
        List orNodes = expr.findDescendantsOfType(ASTConditionalOrExpression.class);
        int complexity = 0;
        if (expr instanceof ASTConditionalOrExpression || expr instanceof ASTConditionalAndExpression) {
            ++complexity;
        }
        for (AbstractJavaTypeNode element : orNodes) {
            complexity += element.jjtGetNumChildren() - 1;
        }
        for (AbstractJavaTypeNode element : andNodes) {
            complexity += element.jjtGetNumChildren() - 1;
        }
        return complexity;
    }

    public static enum CycloOption implements MetricOption
    {
        IGNORE_BOOLEAN_PATHS("ignoreBooleanPaths"),
        CONSIDER_ASSERT("considerAssert");

        private final String vName;

        private CycloOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }
}

