/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;
import net.sourceforge.pmd.properties.StringMultiProperty;

public class FieldNamingConventionsRule
extends AbstractNamingConventionRule<ASTVariableDeclaratorId> {
    private static final StringMultiProperty EXCLUDED_NAMES = ((StringMultiProperty.StringMultiPBuilder)((StringMultiProperty.StringMultiPBuilder)StringMultiProperty.named((String)"exclusions").desc("Names of fields to whitelist.")).defaultValues((Object[])new String[]{"serialVersionUID"})).build();
    private final RegexProperty publicConstantFieldRegex = this.defaultProp("public constant").defaultValue("[A-Z][A-Z_0-9]*").build();
    private final RegexProperty constantFieldRegex = ((RegexProperty.RegexPBuilder)this.defaultProp("constant").desc("Regex which applies to non-public static final field names")).defaultValue("[A-Z][A-Z_0-9]*").build();
    private final RegexProperty enumConstantRegex = this.defaultProp("enum constant").defaultValue("[A-Z][A-Z_0-9]*").build();
    private final RegexProperty finalFieldRegex = this.defaultProp("final field").build();
    private final RegexProperty staticFieldRegex = this.defaultProp("static field").build();
    private final RegexProperty defaultFieldRegex = this.defaultProp("defaultField", "field").build();

    public FieldNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)this.publicConstantFieldRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.constantFieldRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.enumConstantRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.finalFieldRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.staticFieldRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.defaultFieldRegex);
        this.definePropertyDescriptor((PropertyDescriptor)EXCLUDED_NAMES);
        this.addRuleChainVisit(ASTFieldDeclaration.class);
        this.addRuleChainVisit(ASTEnumConstant.class);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        for (ASTVariableDeclaratorId id : node) {
            if (((List)this.getProperty((PropertyDescriptor)EXCLUDED_NAMES)).contains(id.getVariableName())) continue;
            if (node.isFinal() && node.isStatic()) {
                this.checkMatches(id, (PropertyDescriptor<Pattern>)(node.isPublic() ? this.publicConstantFieldRegex : this.constantFieldRegex), data);
                continue;
            }
            if (node.isFinal()) {
                this.checkMatches(id, (PropertyDescriptor<Pattern>)this.finalFieldRegex, data);
                continue;
            }
            if (node.isStatic()) {
                this.checkMatches(id, (PropertyDescriptor<Pattern>)this.staticFieldRegex, data);
                continue;
            }
            this.checkMatches(id, (PropertyDescriptor<Pattern>)this.defaultFieldRegex, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTEnumConstant node, Object data) {
        if (!((Pattern)this.getProperty((PropertyDescriptor)this.enumConstantRegex)).matcher(node.getImage()).matches()) {
            this.addViolation(data, (Node)node, new Object[]{"enum constant", node.getImage(), ((Pattern)this.getProperty((PropertyDescriptor)this.enumConstantRegex)).toString()});
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String kindDisplayName(ASTVariableDeclaratorId node, PropertyDescriptor<Pattern> descriptor) {
        ASTFieldDeclaration field = (ASTFieldDeclaration)node.getNthParent(2);
        if (field.isFinal() && field.isStatic()) {
            return field.isPublic() ? "public constant" : "constant";
        }
        if (field.isFinal()) {
            return "final field";
        }
        if (field.isStatic()) {
            return "static field";
        }
        return "field";
    }
}

