/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;

public final class FormalParameterNamingConventionsRule
extends AbstractNamingConventionRule<ASTVariableDeclaratorId> {
    private final RegexProperty formalParamRegex = this.defaultProp("methodParameter", "formal parameter").build();
    private final RegexProperty finalFormalParamRegex = this.defaultProp("finalMethodParameter", "final formal parameter").build();
    private final RegexProperty lambdaParamRegex = this.defaultProp("lambdaParameter", "inferred-type lambda parameter").build();
    private final RegexProperty explicitLambdaParamRegex = this.defaultProp("explicitLambdaParameter", "explicitly-typed lambda parameter").build();

    public FormalParameterNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)this.formalParamRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.finalFormalParamRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.lambdaParamRegex);
        this.definePropertyDescriptor((PropertyDescriptor)this.explicitLambdaParamRegex);
        this.addRuleChainVisit(ASTVariableDeclaratorId.class);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node.isLambdaParameter()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)(node.isTypeInferred() ? this.lambdaParamRegex : this.explicitLambdaParamRegex), data);
        } else if (node.isFormalParameter()) {
            this.checkMatches(node, (PropertyDescriptor<Pattern>)(node.isFinal() ? this.finalFormalParamRegex : this.formalParamRegex), data);
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String kindDisplayName(ASTVariableDeclaratorId node, PropertyDescriptor<Pattern> descriptor) {
        if (node.isLambdaParameter()) {
            return node.isTypeInferred() ? "lambda parameter" : "explicitly-typed lambda parameter";
        }
        if (node.isFormalParameter()) {
            return node.isFinal() ? "final method parameter" : "method parameter";
        }
        throw new UnsupportedOperationException("This rule doesn't handle this case");
    }
}

