/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractJavaRule {
    private int depth;
    private int depthLimit;
    private static final IntegerProperty PROBLEM_DEPTH_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"problemDepth").desc("The if statement depth reporting threshold")).range((Object)1, (Object)25)).defaultValue((Object)3)).uiOrder(1.0f)).build();

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.depth = 0;
        this.depthLimit = (Integer)this.getProperty((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (!node.hasElse()) {
            ++this.depth;
        }
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, (Node)node);
        }
        --this.depth;
        return data;
    }
}

