/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetricKey;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.java.metrics.impl.NcssMetric;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.ResultOption;
import net.sourceforge.pmd.properties.EnumeratedMultiProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public final class NcssCountRule
extends AbstractJavaMetricsRule {
    private static final IntegerProperty METHOD_REPORT_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"methodReportLevel").desc("NCSS reporting threshold for methods")).range((Object)1, (Object)2000)).defaultValue((Object)60)).build();
    private static final IntegerProperty CLASS_REPORT_LEVEL_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"classReportLevel").desc("NCSS reporting threshold for classes")).range((Object)1, (Object)20000)).defaultValue((Object)1500)).build();
    private static final Map<String, NcssMetric.NcssOption> OPTION_MAP = new HashMap<String, NcssMetric.NcssOption>();
    private static final EnumeratedMultiProperty<NcssMetric.NcssOption> NCSS_OPTIONS_DESCRIPTOR;
    private int methodReportLevel;
    private int classReportLevel;
    private MetricOptions ncssOptions;

    public NcssCountRule() {
        this.definePropertyDescriptor((PropertyDescriptor)METHOD_REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CLASS_REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)NCSS_OPTIONS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.methodReportLevel = (Integer)this.getProperty((PropertyDescriptor)METHOD_REPORT_LEVEL_DESCRIPTOR);
        this.classReportLevel = (Integer)this.getProperty((PropertyDescriptor)CLASS_REPORT_LEVEL_DESCRIPTOR);
        this.ncssOptions = MetricOptions.ofOptions((Collection)((Collection)this.getProperty((PropertyDescriptor)NCSS_OPTIONS_DESCRIPTOR)));
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        super.visit(node, data);
        if (JavaClassMetricKey.NCSS.supports(node)) {
            int classSize = (int)JavaMetrics.get(JavaClassMetricKey.NCSS, node, this.ncssOptions);
            int classHighest = (int)JavaMetrics.get(JavaOperationMetricKey.NCSS, node, this.ncssOptions, ResultOption.HIGHEST);
            if (classSize >= this.classReportLevel) {
                Object[] messageParams = new String[]{node.getTypeKind().name().toLowerCase(Locale.ROOT), node.getImage(), classSize + " (Highest = " + classHighest + ")"};
                this.addViolation(data, node, messageParams);
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodOrConstructorDeclaration node, Object data) {
        int methodSize = (int)JavaMetrics.get((MetricKey<MethodLikeNode>)JavaOperationMetricKey.NCSS, node, this.ncssOptions);
        if (methodSize >= this.methodReportLevel) {
            this.addViolation(data, node, new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", node.getQualifiedName().getOperation(), "" + methodSize});
        }
        return data;
    }

    static {
        OPTION_MAP.put(NcssMetric.NcssOption.COUNT_IMPORTS.valueName(), NcssMetric.NcssOption.COUNT_IMPORTS);
        NCSS_OPTIONS_DESCRIPTOR = new EnumeratedMultiProperty("ncssOptions", "Choose options for the calculation of Ncss", OPTION_MAP, Collections.emptyList(), NcssMetric.NcssOption.class, 3.0f);
    }
}

