/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.documentation.AbstractCommentRule;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class CommentSizeRule
extends AbstractCommentRule {
    public static final IntegerProperty MAX_LINES = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"maxLines").desc("Maximum lines")).range((Object)2, (Object)200)).defaultValue((Object)6)).uiOrder(2.0f)).build();
    public static final IntegerProperty MAX_LINE_LENGTH = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"maxLineLength").desc("Maximum line length")).range((Object)1, (Object)200)).defaultValue((Object)80)).uiOrder(2.0f)).build();
    private static final String CR = "\n";

    public CommentSizeRule() {
        this.definePropertyDescriptor((PropertyDescriptor)MAX_LINES);
        this.definePropertyDescriptor((PropertyDescriptor)MAX_LINE_LENGTH);
    }

    private static boolean hasRealText(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return false;
        }
        return !StringUtil.isAnyOf((String)line.trim(), (String[])new String[]{"//", "/*", "/**", "*", "*/"});
    }

    private boolean hasTooManyLines(Comment comment) {
        int end;
        int start;
        String[] lines = comment.getImage().split(CR);
        for (start = 0; start < lines.length && !CommentSizeRule.hasRealText(lines[start]); ++start) {
        }
        for (end = lines.length - 1; end > 0 && !CommentSizeRule.hasRealText(lines[end]); --end) {
        }
        int lineCount = end - start + 1;
        return lineCount > (Integer)this.getProperty((PropertyDescriptor)MAX_LINES);
    }

    private String withoutCommentMarkup(String text) {
        return StringUtil.withoutPrefixes((String)text.trim(), (String[])new String[]{"//", "*", "/**"});
    }

    private List<Integer> overLengthLineIndicesIn(Comment comment) {
        int maxLength = (Integer)this.getProperty((PropertyDescriptor)MAX_LINE_LENGTH);
        ArrayList<Integer> indicies = new ArrayList<Integer>();
        String[] lines = comment.getImage().split(CR);
        int offset = comment.getBeginLine();
        for (int i = 0; i < lines.length; ++i) {
            String cleaned = this.withoutCommentMarkup(lines[i]);
            if (cleaned.length() <= maxLength) continue;
            indicies.add(i + offset);
        }
        return indicies;
    }

    @Override
    public Object visit(ASTCompilationUnit cUnit, Object data) {
        for (Comment comment : cUnit.getComments()) {
            List<Integer> lineNumbers;
            if (this.hasTooManyLines(comment)) {
                this.addViolationWithMessage(data, cUnit, this.getMessage() + ": Too many lines", comment.getBeginLine(), comment.getEndLine());
            }
            if ((lineNumbers = this.overLengthLineIndicesIn(comment)).isEmpty()) continue;
            for (Integer lineNum : lineNumbers) {
                this.addViolationWithMessage(data, cUnit, this.getMessage() + ": Line too long", lineNum, lineNum);
            }
        }
        return super.visit(cUnit, data);
    }
}

