/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.performance.AbstractOptimizationRule;

public class AvoidInstantiatingObjectsInLoopsRule
extends AbstractOptimizationRule {
    @Override
    public Object visit(ASTAllocationExpression node, Object data) {
        if (this.insideLoop(node) && this.fourthParentNotThrow(node) && this.fourthParentNotReturn(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean fourthParentNotThrow(ASTAllocationExpression node) {
        return !(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTThrowStatement);
    }

    private boolean fourthParentNotReturn(ASTAllocationExpression node) {
        return !(node.jjtGetParent().jjtGetParent().jjtGetParent().jjtGetParent() instanceof ASTReturnStatement);
    }

    private boolean insideLoop(ASTAllocationExpression node) {
        for (Node n = node.jjtGetParent(); n != null; n = n.jjtGetParent()) {
            if (n instanceof ASTDoStatement || n instanceof ASTWhileStatement || n instanceof ASTForStatement) {
                return true;
            }
            if (n instanceof ASTForInit) {
                n = n.jjtGetParent();
                continue;
            }
            if (!(n.jjtGetParent() instanceof ASTForStatement) || n.jjtGetParent().jjtGetNumChildren() <= 1 || n != n.jjtGetParent().jjtGetChild(1)) continue;
            n = n.jjtGetParent();
        }
        return false;
    }
}

