/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.RegexProperty;
import net.sourceforge.pmd.util.StringUtil;

abstract class AbstractNamingConventionRule<T extends JavaNode>
extends AbstractJavaRule {
    static final String CAMEL_CASE = "[a-z][a-zA-Z0-9]*";
    static final String PASCAL_CASE = "[A-Z][a-zA-Z0-9]*";

    AbstractNamingConventionRule() {
    }

    RegexProperty.RegexPBuilder defaultProp(String displayName) {
        return this.defaultProp(StringUtil.toCamelCase((String)displayName, (boolean)true), displayName);
    }

    RegexProperty.RegexPBuilder defaultProp(String name, String displayName) {
        return ((RegexProperty.RegexPBuilder)RegexProperty.named((String)(name + "Pattern")).desc("Regex which applies to " + displayName.trim() + " names")).defaultValue(this.defaultConvention());
    }

    abstract String defaultConvention();

    abstract String kindDisplayName(T var1, PropertyDescriptor<Pattern> var2);

    String nameExtractor(T node) {
        return node.getImage();
    }

    void checkMatches(T node, PropertyDescriptor<Pattern> regex, Object data) {
        String name = this.nameExtractor(node);
        if (!((Pattern)this.getProperty(regex)).matcher(name).matches()) {
            this.addViolation(data, (Node)node, new Object[]{this.kindDisplayName(node, regex), name, ((Pattern)this.getProperty(regex)).toString()});
        }
    }
}

