/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.BooleanProperty;
import net.sourceforge.pmd.properties.CharacterProperty;
import net.sourceforge.pmd.properties.FileProperty;
import net.sourceforge.pmd.properties.IntegerProperty;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.StringProperty;
import org.apache.commons.lang3.StringUtils;

public class AvoidDuplicateLiteralsRule
extends AbstractJavaRule {
    public static final IntegerProperty THRESHOLD_DESCRIPTOR = ((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)((IntegerProperty.IntegerPBuilder)IntegerProperty.named((String)"maxDuplicateLiterals").desc("Max duplicate literals")).range((Object)1, (Object)20)).defaultValue((Object)4)).uiOrder(1.0f)).build();
    public static final IntegerProperty MINIMUM_LENGTH_DESCRIPTOR = new IntegerProperty("minimumLength", "Minimum string length to check", Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(3), 1.5f);
    public static final BooleanProperty SKIP_ANNOTATIONS_DESCRIPTOR = new BooleanProperty("skipAnnotations", "Skip literals within annotations", false, 2.0f);
    public static final StringProperty EXCEPTION_LIST_DESCRIPTOR = new StringProperty("exceptionList", "Strings to ignore", null, 3.0f);
    public static final CharacterProperty SEPARATOR_DESCRIPTOR = new CharacterProperty("separator", "Ignore list separator", Character.valueOf(','), 4.0f);
    public static final FileProperty EXCEPTION_FILE_DESCRIPTOR = new FileProperty("exceptionfile", "File containing strings to skip (one string per line), only used if ignore list is not set", null, 5.0f);
    private Map<String, List<ASTLiteral>> literals = new HashMap<String, List<ASTLiteral>>();
    private Set<String> exceptions = new HashSet<String>();
    private int minLength;

    public AvoidDuplicateLiteralsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)THRESHOLD_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MINIMUM_LENGTH_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SKIP_ANNOTATIONS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)EXCEPTION_LIST_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)SEPARATOR_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)EXCEPTION_FILE_DESCRIPTOR);
    }

    private LineNumberReader getLineReader() throws FileNotFoundException {
        return new LineNumberReader(new BufferedReader(new FileReader((File)this.getProperty((PropertyDescriptor)EXCEPTION_FILE_DESCRIPTOR))));
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.literals.clear();
        if (this.getProperty((PropertyDescriptor)EXCEPTION_LIST_DESCRIPTOR) != null) {
            ExceptionParser p = new ExceptionParser(((Character)this.getProperty((PropertyDescriptor)SEPARATOR_DESCRIPTOR)).charValue());
            this.exceptions = p.parse((String)this.getProperty((PropertyDescriptor)EXCEPTION_LIST_DESCRIPTOR));
        } else if (this.getProperty((PropertyDescriptor)EXCEPTION_FILE_DESCRIPTOR) != null) {
            this.exceptions = new HashSet<String>();
            try (LineNumberReader reader = this.getLineReader();){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.exceptions.add(line);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        this.minLength = 2 + (Integer)this.getProperty((PropertyDescriptor)MINIMUM_LENGTH_DESCRIPTOR);
        super.visit(node, data);
        this.processResults(data);
        return data;
    }

    private void processResults(Object data) {
        int threshold = (Integer)this.getProperty((PropertyDescriptor)THRESHOLD_DESCRIPTOR);
        for (Map.Entry<String, List<ASTLiteral>> entry : this.literals.entrySet()) {
            List<ASTLiteral> occurrences = entry.getValue();
            if (occurrences.size() < threshold) continue;
            ASTLiteral first = occurrences.get(0);
            String rawImage = first.getEscapedStringLiteral();
            Object[] args = new Object[]{rawImage, occurrences.size(), first.getBeginLine()};
            this.addViolation(data, first, args);
        }
    }

    @Override
    public Object visit(ASTLiteral node, Object data) {
        if (!node.isStringLiteral()) {
            return data;
        }
        String image = node.getImage();
        if (image.length() < this.minLength) {
            return data;
        }
        if (this.exceptions.contains(image.substring(1, image.length() - 1))) {
            return data;
        }
        if (((Boolean)this.getProperty((PropertyDescriptor)SKIP_ANNOTATIONS_DESCRIPTOR)).booleanValue() && node.getFirstParentOfType(ASTAnnotation.class) != null) {
            return data;
        }
        if (this.literals.containsKey(image)) {
            List<ASTLiteral> occurrences = this.literals.get(image);
            occurrences.add(node);
        } else {
            ArrayList<ASTLiteral> occurrences = new ArrayList<ASTLiteral>();
            occurrences.add(node);
            this.literals.put(image, occurrences);
        }
        return data;
    }

    private static String checkFile(File file) {
        if (!file.exists()) {
            return "File '" + file.getName() + "' does not exist";
        }
        if (!file.canRead()) {
            return "File '" + file.getName() + "' cannot be read";
        }
        if (file.length() == 0L) {
            return "File '" + file.getName() + "' is empty";
        }
        return null;
    }

    public String dysfunctionReason() {
        File file = (File)this.getProperty((PropertyDescriptor)EXCEPTION_FILE_DESCRIPTOR);
        if (file != null) {
            String issue = AvoidDuplicateLiteralsRule.checkFile(file);
            if (issue != null) {
                return issue;
            }
            String ignores = (String)this.getProperty((PropertyDescriptor)EXCEPTION_LIST_DESCRIPTOR);
            if (StringUtils.isNotBlank((CharSequence)ignores)) {
                return "Cannot reference external file AND local values";
            }
        }
        return null;
    }

    public static class ExceptionParser {
        private static final char ESCAPE_CHAR = '\\';
        private char delimiter;

        public ExceptionParser(char delimiter) {
            this.delimiter = delimiter;
        }

        public Set<String> parse(String s) {
            HashSet<String> result = new HashSet<String>();
            StringBuilder currentToken = new StringBuilder();
            boolean inEscapeMode = false;
            for (int i = 0; i < s.length(); ++i) {
                if (inEscapeMode) {
                    inEscapeMode = false;
                    currentToken.append(s.charAt(i));
                    continue;
                }
                if (s.charAt(i) == '\\') {
                    inEscapeMode = true;
                    continue;
                }
                if (s.charAt(i) == this.delimiter) {
                    result.add(currentToken.toString());
                    currentToken = new StringBuilder();
                    continue;
                }
                currentToken.append(s.charAt(i));
            }
            if (currentToken.length() > 0) {
                result.add(currentToken.toString());
            }
            return result;
        }
    }
}

