/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.Objects;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymFactory;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymbolMakerVisitor;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstSymbolicAnnot;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.PSet;

public final class SymbolResolutionPass {
    private SymbolResolutionPass() {
    }

    public static SymbolResolver traverse(JavaAstProcessor processor, ASTCompilationUnit root) {
        AstSymbolMakerVisitor visitor = new AstSymbolMakerVisitor(root);
        ((AbstractJavaNode)root).acceptVisitor(visitor, new AstSymFactory(processor));
        return visitor.makeKnownSymbolResolver();
    }

    public static PSet<SymbolicValue.SymAnnot> buildSymbolicAnnotations(NodeStream<ASTAnnotation> annotations) {
        return (PSet)annotations.toStream().map(SymbolResolutionPass::toValidAnnotation).filter(Objects::nonNull).collect(CollectionUtil.toPersistentSet());
    }

    private static @Nullable SymbolicValue.SymAnnot toValidAnnotation(ASTAnnotation node) {
        JTypeDeclSymbol sym = InternalApiBridge.getReferencedSym(node.getTypeNode());
        if (sym instanceof JClassSymbol) {
            return new AstSymbolicAnnot(node, (JClassSymbol)sym);
        }
        return null;
    }
}

