/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.table.coreimpl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.CachingShadowChainNode;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.CoreResolvers;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.MostlySingularMultimap;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNode;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainNodeBase;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainRoot;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ShadowChainBuilder<S, I> {
    private final MostlySingularMultimap.MapMaker<String> mapMaker = this::copyToMutable;

    MostlySingularMultimap.Builder<String, S> newMapBuilder() {
        return MostlySingularMultimap.newBuilder(this.mapMaker);
    }

    protected <V> Map<String, V> copyToMutable(Map<String, V> m) {
        return new LinkedHashMap<String, V>(m);
    }

    public abstract String getSimpleName(S var1);

    public static <S, I> ShadowChainNode<S, I> rootGroup() {
        return ShadowChainRoot.empty();
    }

    public ShadowChainNode<S, I> augment(ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, ResolverBuilder symbols) {
        if (this.isPrunable(parent, shadowBarrier, symbols.isEmpty())) {
            return parent;
        }
        return new ShadowChainNodeBase<S, I>(parent, shadowBarrier, scopeTag, symbols.build());
    }

    public ShadowChainNode<S, I> augment(ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, NameResolver<? extends S> resolver) {
        if (this.isPrunable(parent, shadowBarrier, resolver.isDefinitelyEmpty())) {
            return parent;
        }
        return new ShadowChainNodeBase<S, I>(parent, shadowBarrier, scopeTag, resolver);
    }

    private boolean isPrunable(ShadowChainNode<S, I> parent, boolean shadowBarrier, boolean definitelyEmpty) {
        return definitelyEmpty && (!shadowBarrier || parent.getResolver().isDefinitelyEmpty() && parent.isShadowBarrier());
    }

    public ShadowChainNode<S, I> augment(ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, S symbol) {
        return new ShadowChainNodeBase<S, I>(parent, shadowBarrier, scopeTag, CoreResolvers.singleton(this.getSimpleName(symbol), symbol));
    }

    public ShadowChainNode<S, I> augmentWithCache(ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, NameResolver<? extends S> resolver) {
        return this.augmentWithCache(parent, shadowBarrier, scopeTag, resolver, ShadowChainNodeBase.defaultMerger());
    }

    public ShadowChainNode<S, I> augmentWithCache(ShadowChainNode<S, I> parent, boolean shadowBarrier, I scopeTag, NameResolver<? extends S> resolver, BinaryOperator<List<S>> merger) {
        return new CachingShadowChainNode<S, I>(parent, new HashMap(), resolver, shadowBarrier, scopeTag, merger);
    }

    public ShadowChainNode<S, I> shadowWithCache(ShadowChainNode<S, I> parent, I scopeTag, Map<String, List<S>> cacheMap, NameResolver<S> resolver) {
        return new CachingShadowChainNode<S, I>(parent, cacheMap, resolver, true, scopeTag, ShadowChainNodeBase.defaultMerger());
    }

    public ShadowChainNode<S, I> shadow(ShadowChainNode<S, I> parent, I scopeTag, ResolverBuilder resolver) {
        return this.augment(parent, true, scopeTag, (S)resolver);
    }

    public ShadowChainNode<S, I> shadow(ShadowChainNode<S, I> parent, I scopeTag, NameResolver<S> resolver) {
        return this.augment(parent, true, scopeTag, (S)resolver);
    }

    public ShadowChainNode<S, I> shadow(ShadowChainNode<S, I> parent, I scopeTag, S symbol) {
        return this.augment(parent, true, scopeTag, symbol);
    }

    public <N> ResolverBuilder groupByName(Iterable<? extends N> input, Function<? super N, ? extends @Nullable S> symbolFetcher) {
        Iterable mapped = () -> IteratorUtil.mapNotNull(input.iterator(), (Function)symbolFetcher);
        return new ResolverBuilder(this.newMapBuilder().groupBy(mapped, this::getSimpleName));
    }

    public ResolverBuilder groupByName(Iterable<? extends S> tparams) {
        return new ResolverBuilder(this.newMapBuilder().groupBy(tparams, this::getSimpleName));
    }

    public NameResolver<S> groupByName(S sym) {
        return CoreResolvers.singleton(this.getSimpleName(sym), sym);
    }

    public class ResolverBuilder {
        private final MostlySingularMultimap.Builder<String, S> myBuilder;

        public ResolverBuilder(MostlySingularMultimap.Builder<String, S> myBuilder) {
            this.myBuilder = myBuilder;
        }

        public ResolverBuilder() {
            this.myBuilder = ShadowChainBuilder.this.newMapBuilder();
        }

        public String getSimpleName(S sym) {
            return ShadowChainBuilder.this.getSimpleName(sym);
        }

        public ResolverBuilder append(S sym) {
            this.myBuilder.appendValue(this.getSimpleName(sym), sym);
            return this;
        }

        public ResolverBuilder appendWithoutDuplicate(S sym) {
            this.myBuilder.appendValue(this.getSimpleName(sym), sym, true);
            return this;
        }

        public ResolverBuilder overwrite(S sym) {
            this.myBuilder.replaceValue(this.getSimpleName(sym), sym);
            return this;
        }

        public ResolverBuilder absorb(ResolverBuilder other) {
            this.myBuilder.absorb(other.myBuilder);
            return this;
        }

        public Map<String, List<S>> getMutableMap() {
            return this.myBuilder.getMutableMap();
        }

        public NameResolver<S> build() {
            if (this.isEmpty()) {
                return CoreResolvers.emptyResolver();
            }
            if (this.myBuilder.isSingular()) {
                Map singular = this.myBuilder.buildAsSingular();
                assert (singular != null);
                if (singular.size() == 1) {
                    Map.Entry pair = singular.entrySet().iterator().next();
                    return CoreResolvers.singleton(pair.getKey(), pair.getValue());
                }
                return CoreResolvers.singularMapResolver(singular);
            }
            return CoreResolvers.multimapResolver(this.myBuilder.build());
        }

        public boolean isEmpty() {
            return this.myBuilder.isEmpty();
        }
    }
}

