/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.PVector;
import org.pcollections.TreePVector;

public final class ConstructorCallsOverridableMethodRule
extends AbstractJavaRulechainRule {
    private static final String MESSAGE = "Overridable method called during object construction: {0} ";
    private static final String MESSAGE_TRANSITIVE = "This method may call an overridable method during object construction: {0} (call stack: [{1}])";
    private final Map<JMethodSymbol, Deque<JMethodSymbol>> safeMethods = new HashMap<JMethodSymbol, Deque<JMethodSymbol>>();
    private static final Deque<JMethodSymbol> EMPTY_STACK = new LinkedList<JMethodSymbol>();
    private static final Set<String> MAKE_FIELD_FINAL_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.Value", (Object[])new String[0]);

    public ConstructorCallsOverridableMethodRule() {
        super(ASTConstructorDeclaration.class, new Class[0]);
    }

    public void start(RuleContext ctx) {
        super.start(ctx);
        this.safeMethods.clear();
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.getEnclosingType().isFinal() || JavaAstUtils.hasAnyAnnotation(node.getEnclosingType(), MAKE_FIELD_FINAL_CLASS_ANNOT)) {
            return null;
        }
        for (ASTMethodCall call : node.getBody().descendants(ASTMethodCall.class)) {
            Deque<JMethodSymbol> unsafetyReason = this.getUnsafetyReason(call, (PVector<ASTMethodDeclaration>)TreePVector.empty());
            if (unsafetyReason.isEmpty()) continue;
            JMethodSig overload = call.getOverloadSelectionInfo().getMethodType();
            JMethodSig unsafeMethod = call.getTypeSystem().sigOf(unsafetyReason.getLast());
            String message = unsafeMethod.equals(overload) ? MESSAGE : MESSAGE_TRANSITIVE;
            String lastMethod = PrettyPrintingUtil.prettyPrintOverload(unsafetyReason.getLast());
            String stack = unsafetyReason.stream().map(PrettyPrintingUtil::prettyPrintOverload).collect(Collectors.joining(", "));
            this.asCtx(data).addViolationWithMessage((Node)call, message, new Object[]{lastMethod, stack});
        }
        return null;
    }

    private @NonNull Deque<JMethodSymbol> getUnsafetyReason(ASTMethodCall call, PVector<ASTMethodDeclaration> recursionGuard) {
        if (!ConstructorCallsOverridableMethodRule.isCallOnThisInstance(call)) {
            return EMPTY_STACK;
        }
        OverloadSelectionResult overload = call.getOverloadSelectionInfo();
        if (overload.isFailed()) {
            return EMPTY_STACK;
        }
        JMethodSymbol method = (JMethodSymbol)overload.getMethodType().getSymbol();
        if (ConstructorCallsOverridableMethodRule.isOverridable(method)) {
            LinkedList<JMethodSymbol> stack = new LinkedList<JMethodSymbol>();
            stack.addFirst(method);
            return stack;
        }
        return this.getUnsafetyReason(method, recursionGuard);
    }

    private @NonNull Deque<JMethodSymbol> getUnsafetyReason(JMethodSymbol method, PVector<ASTMethodDeclaration> recursionGuard) {
        if (method.isStatic()) {
            return EMPTY_STACK;
        }
        ASTMethodDeclaration declaration = (ASTMethodDeclaration)method.tryGetNode();
        if (declaration == null) {
            return EMPTY_STACK;
        }
        if (recursionGuard.contains((Object)declaration)) {
            return EMPTY_STACK;
        }
        if (this.safeMethods.containsKey(method)) {
            return this.safeMethods.get(method);
        }
        PVector deeperRecursion = recursionGuard.plus((Object)declaration);
        for (ASTMethodCall call : NodeStream.of((Node)declaration.getBody()).descendants(ASTMethodCall.class).filter(ConstructorCallsOverridableMethodRule::isCallOnThisInstance)) {
            Deque<JMethodSymbol> unsafetyReason = this.getUnsafetyReason(call, (PVector<ASTMethodDeclaration>)deeperRecursion);
            if (unsafetyReason.isEmpty()) continue;
            this.safeMethods.putIfAbsent(method, new LinkedList<JMethodSymbol>(unsafetyReason));
            this.safeMethods.get(method).addFirst(method);
            return this.safeMethods.get(method);
        }
        this.safeMethods.remove(method);
        return EMPTY_STACK;
    }

    private static boolean isCallOnThisInstance(ASTMethodCall call) {
        ASTExpression qualifier = call.getQualifier();
        return qualifier == null || JavaAstUtils.isUnqualifiedThis(qualifier);
    }

    private static boolean isOverridable(JExecutableSymbol method) {
        return (0x1A & method.getModifiers()) == 0;
    }
}

