/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypeVarImpl;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TypeConversion {
    private TypeConversion() {
    }

    public static JTypeMirror unaryNumericPromotion(JTypeMirror t) {
        t = t.unbox();
        TypeSystem ts = t.getTypeSystem();
        if (t.isPrimitive(JPrimitiveType.PrimitiveTypeKind.BYTE) || t.isPrimitive(JPrimitiveType.PrimitiveTypeKind.SHORT) || t.isPrimitive(JPrimitiveType.PrimitiveTypeKind.CHAR)) {
            return ts.INT;
        }
        return t.isNumeric() || t == ts.UNKNOWN ? t : ts.ERROR;
    }

    public static JTypeMirror binaryNumericPromotion(JTypeMirror t, JTypeMirror s) {
        JTypeMirror t1 = t.unbox();
        JTypeMirror s1 = s.unbox();
        TypeSystem ts = t.getTypeSystem();
        if (t1.isPrimitive(JPrimitiveType.PrimitiveTypeKind.DOUBLE) || s1.isPrimitive(JPrimitiveType.PrimitiveTypeKind.DOUBLE)) {
            return ts.DOUBLE;
        }
        if (t1.isPrimitive(JPrimitiveType.PrimitiveTypeKind.FLOAT) || s1.isPrimitive(JPrimitiveType.PrimitiveTypeKind.FLOAT)) {
            return ts.FLOAT;
        }
        if (t1.isPrimitive(JPrimitiveType.PrimitiveTypeKind.LONG) || s1.isPrimitive(JPrimitiveType.PrimitiveTypeKind.LONG)) {
            return ts.LONG;
        }
        if (t1.isNumeric() && s1.isNumeric()) {
            return ts.INT;
        }
        return ts.ERROR;
    }

    public static boolean isConvertibleUsingBoxing(JTypeMirror t, JTypeMirror s) {
        return TypeConversion.isConvertibleCommon(t, s, false);
    }

    public static boolean isConvertibleInCastContext(JTypeMirror t, JTypeMirror s) {
        return TypeConversion.isConvertibleCommon(t, s, true);
    }

    private static boolean isConvertibleCommon(JTypeMirror t, JTypeMirror s, boolean isCastContext) {
        TypeSystem ts = t.getTypeSystem();
        if (t == ts.UNKNOWN || t == ts.ERROR) {
            return true;
        }
        if (t instanceof InferenceVar || s instanceof InferenceVar) {
            return t.box().isSubtypeOf(s.box());
        }
        if (t.isPrimitive() == s.isPrimitive()) {
            return t.isConvertibleTo(s).bySubtyping();
        }
        if (isCastContext) {
            return t.isPrimitive() ? t.box().isConvertibleTo(s).bySubtyping() : t.isConvertibleTo(s.box()).bySubtyping();
        }
        return t.isPrimitive() ? t.box().isConvertibleTo(s).somehow() : t.unbox().isConvertibleTo(s).somehow();
    }

    public static JTypeMirror capture(JTypeMirror t) {
        return t instanceof JClassType ? TypeConversion.capture((JClassType)t) : t;
    }

    public static JClassType capture(JClassType type) {
        if (type == null) {
            return null;
        }
        @Nullable JClassType enclosing = TypeConversion.capture(type.getEnclosingType());
        if (enclosing == type.getEnclosingType() && !TypeConversion.isWilcardParameterized(type)) {
            return type;
        }
        TypeSystem ts = type.getTypeSystem();
        List<JTypeMirror> typeArgs = type.getTypeArgs();
        List<JTypeVar> typeParams = type.getFormalTypeParams();
        List<JTypeMirror> freshVars = TypeConversion.makeFreshVars(type);
        boolean wellFormed = typeParams.size() == freshVars.size();
        Substitution subst = wellFormed ? Substitution.mapping(typeParams, freshVars) : Substitution.EMPTY;
        for (int i = 0; i < typeArgs.size(); ++i) {
            JTypeMirror fresh = freshVars.get(i);
            JTypeMirror arg = typeArgs.get(i);
            if (!(arg instanceof JWildcardType)) continue;
            JWildcardType w = (JWildcardType)arg;
            TypeVarImpl.CapturedTypeVar freshVar = (TypeVarImpl.CapturedTypeVar)fresh;
            JClassType prevUpper = wellFormed ? typeParams.get(i).getUpperBound() : ts.OBJECT;
            JTypeMirror substituted = TypeOps.subst(prevUpper, (Function<? super SubstVar, ? extends JTypeMirror>)subst);
            if (w.isUnbounded()) {
                freshVar.setUpperBound(substituted);
                freshVar.setLowerBound(ts.NULL_TYPE);
                continue;
            }
            if (w.isUpperBound()) {
                freshVar.setUpperBound(ts.glb(Arrays.asList(substituted, w.getBound())));
                freshVar.setLowerBound(ts.NULL_TYPE);
                continue;
            }
            freshVar.setUpperBound(substituted);
            freshVar.setLowerBound(w.getBound());
        }
        if (enclosing != null) {
            return enclosing.selectInner(type.getSymbol(), freshVars);
        }
        return type.withTypeArguments(freshVars);
    }

    public static boolean isWilcardParameterized(JTypeMirror t) {
        return t instanceof JClassType && CollectionUtil.any(((JClassType)t).getTypeArgs(), it -> it instanceof JWildcardType);
    }

    private static List<JTypeMirror> makeFreshVars(JClassType type) {
        ArrayList<JTypeMirror> freshVars = new ArrayList<JTypeMirror>(type.getTypeArgs().size());
        for (JTypeMirror typeArg : type.getTypeArgs()) {
            if (typeArg instanceof JWildcardType) {
                freshVars.add(TypeVarImpl.freshCapture((JWildcardType)typeArg));
                continue;
            }
            freshVars.add(typeArg);
        }
        return freshVars;
    }
}

