/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;

public class NPathComplexityRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("N-Path Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)200)).build();

    public NPathComplexityRule() {
        super(ASTExecutableDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        return this.visitMethod((ASTExecutableDeclaration)node, (RuleContext)data);
    }

    private Object visitMethod(ASTExecutableDeclaration node, RuleContext data) {
        int reportLevel = (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
        if (!JavaMetrics.NPATH_COMP.supports((Node)node)) {
            return data;
        }
        long npath = (Long)MetricsUtil.computeMetric(JavaMetrics.NPATH_COMP, (Node)node);
        if (npath >= (long)reportLevel) {
            this.asCtx(data).addViolation((Node)node, new Object[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", PrettyPrintingUtil.displaySignature(node), String.valueOf(npath), String.valueOf(reportLevel)});
        }
        return data;
    }
}

