/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Collection;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.reporting.RuleContext;

public class CollectionTypeMismatchRule
extends AbstractJavaRulechainRule {
    private static final InvocationMatcher COLLECTION_CONTAINS = InvocationMatcher.parse("java.util.Collection#contains(java.lang.Object)");
    private static final InvocationMatcher COLLECTION_REMOVE = InvocationMatcher.parse("java.util.Collection#remove(java.lang.Object)");
    private static final InvocationMatcher LIST_INDEX_OF = InvocationMatcher.parse("java.util.List#indexOf(java.lang.Object)");
    private static final InvocationMatcher LIST_LAST_INDEX_OF = InvocationMatcher.parse("java.util.List#lastIndexOf(java.lang.Object)");
    private static final InvocationMatcher DEQUE_REMOVE_FIRST_OCCURRENCE = InvocationMatcher.parse("java.util.Deque#removeFirstOccurrence(java.lang.Object)");
    private static final InvocationMatcher DEQUE_REMOVE_LAST_OCCURRENCE = InvocationMatcher.parse("java.util.Deque#removeLastOccurrence(java.lang.Object)");
    private static final InvocationMatcher COLLECTION_REMOVE_ALL = InvocationMatcher.parse("java.util.Collection#removeAll(java.util.Collection)");
    private static final InvocationMatcher COLLECTION_RETAIN_ALL = InvocationMatcher.parse("java.util.Collection#retainAll(java.util.Collection)");
    private static final InvocationMatcher COLLECTION_CONTAINS_ALL = InvocationMatcher.parse("java.util.Collection#containsAll(java.util.Collection)");
    private static final InvocationMatcher MAP_CONTAINS_KEY = InvocationMatcher.parse("java.util.Map#containsKey(java.lang.Object)");
    private static final InvocationMatcher MAP_GET = InvocationMatcher.parse("java.util.Map#get(java.lang.Object)");
    private static final InvocationMatcher MAP_GET_OR_DEFAULT = InvocationMatcher.parse("java.util.Map#getOrDefault(java.lang.Object,_)");
    private static final InvocationMatcher MAP_REMOVE_ONE_PARAM = InvocationMatcher.parse("java.util.Map#remove(java.lang.Object)");
    private static final InvocationMatcher MAP_CONTAINS_VALUE = InvocationMatcher.parse("java.util.Map#containsValue(java.lang.Object)");
    private static final InvocationMatcher HASHTABLE_CONTAINS = InvocationMatcher.parse("java.util.Hashtable#contains(java.lang.Object)");
    private static final InvocationMatcher CONCURRENT_HASHMAP_CONTAINS = InvocationMatcher.parse("java.util.concurrent.ConcurrentHashMap#contains(java.lang.Object)");
    private static final InvocationMatcher MAP_REMOVE_TWO_PARAM = InvocationMatcher.parse("java.util.Map#remove(java.lang.Object,java.lang.Object)");

    public CollectionTypeMismatchRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    public Object visit(ASTMethodCall node, Object data) {
        RuleContext ctx = (RuleContext)data;
        if (COLLECTION_CONTAINS.matchesCall(node) || COLLECTION_REMOVE.matchesCall(node) || LIST_INDEX_OF.matchesCall(node) || LIST_LAST_INDEX_OF.matchesCall(node) || DEQUE_REMOVE_FIRST_OCCURRENCE.matchesCall(node) || DEQUE_REMOVE_LAST_OCCURRENCE.matchesCall(node)) {
            this.checkCollectionElementCompatibility(node, ctx);
        } else if (COLLECTION_REMOVE_ALL.matchesCall(node) || COLLECTION_RETAIN_ALL.matchesCall(node) || COLLECTION_CONTAINS_ALL.matchesCall(node)) {
            this.checkCollectionToCollectionCompatibility(node, ctx);
        } else if (MAP_CONTAINS_KEY.matchesCall(node) || MAP_GET.matchesCall(node) || MAP_GET_OR_DEFAULT.matchesCall(node) || MAP_REMOVE_ONE_PARAM.matchesCall(node)) {
            this.checkMapKeyCompatibility(node, ctx);
        } else if (MAP_CONTAINS_VALUE.matchesCall(node) || HASHTABLE_CONTAINS.matchesCall(node) || CONCURRENT_HASHMAP_CONTAINS.matchesCall(node)) {
            this.checkMapValueCompatibility(node, ctx);
        } else if (MAP_REMOVE_TWO_PARAM.matchesCall(node)) {
            this.checkMapKeyValueCompatibility(node, ctx);
        }
        return null;
    }

    private void checkCollectionElementCompatibility(ASTMethodCall node, RuleContext ctx) {
        JTypeMirror qualifierType = this.getQualifierType(node);
        if (!(qualifierType instanceof JClassType)) {
            return;
        }
        JTypeMirror elementType = this.getCollectionElementType((JClassType)qualifierType);
        if (elementType == null) {
            return;
        }
        ASTExpression firstArg = this.getFirstArgument(node);
        JTypeMirror argType = firstArg.getTypeMirror();
        if (!this.isCompatibleType(argType, elementType)) {
            ctx.addViolation((Node)node, new Object[]{argType.toString(), elementType.toString()});
        }
    }

    private void checkCollectionToCollectionCompatibility(ASTMethodCall node, RuleContext ctx) {
        JTypeMirror argElementType;
        JTypeMirror qualifierType = this.getQualifierType(node);
        if (!(qualifierType instanceof JClassType)) {
            return;
        }
        JTypeMirror elementType = this.getCollectionElementType((JClassType)qualifierType);
        if (elementType == null) {
            return;
        }
        ASTExpression firstArg = this.getFirstArgument(node);
        JTypeMirror argType = firstArg.getTypeMirror();
        if (argType instanceof JClassType && this.isCollectionType((JClassType)argType) && (argElementType = this.getCollectionElementType((JClassType)argType)) != null && !this.isCompatibleType(argElementType, elementType)) {
            ctx.addViolation((Node)node, new Object[]{argElementType.toString(), elementType.toString()});
        }
    }

    private void checkMapKeyCompatibility(ASTMethodCall node, RuleContext ctx) {
        JTypeMirror qualifierType = this.getQualifierType(node);
        if (!(qualifierType instanceof JClassType)) {
            return;
        }
        JTypeMirror keyType = this.getMapKeyType((JClassType)qualifierType);
        if (keyType == null) {
            return;
        }
        ASTExpression firstArg = this.getFirstArgument(node);
        JTypeMirror argType = firstArg.getTypeMirror();
        if (!this.isCompatibleType(argType, keyType)) {
            ctx.addViolation((Node)node, new Object[]{argType.toString(), keyType.toString()});
        }
    }

    private void checkMapValueCompatibility(ASTMethodCall node, RuleContext ctx) {
        JTypeMirror qualifierType = this.getQualifierType(node);
        if (!(qualifierType instanceof JClassType)) {
            return;
        }
        JTypeMirror valueType = this.getMapValueType((JClassType)qualifierType);
        if (valueType == null) {
            return;
        }
        ASTExpression firstArg = this.getFirstArgument(node);
        JTypeMirror argType = firstArg.getTypeMirror();
        if (!this.isCompatibleType(argType, valueType)) {
            ctx.addViolation((Node)node, new Object[]{argType.toString(), valueType.toString()});
        }
    }

    private void checkMapKeyValueCompatibility(ASTMethodCall node, RuleContext ctx) {
        JTypeMirror qualifierType = this.getQualifierType(node);
        if (!(qualifierType instanceof JClassType)) {
            return;
        }
        JTypeMirror keyType = this.getMapKeyType((JClassType)qualifierType);
        JTypeMirror valueType = this.getMapValueType((JClassType)qualifierType);
        if (keyType == null || valueType == null) {
            return;
        }
        ASTExpression keyArg = this.getFirstArgument(node);
        ASTExpression valueArg = this.getSecondArgument(node);
        JTypeMirror keyArgType = keyArg.getTypeMirror();
        JTypeMirror valueArgType = valueArg.getTypeMirror();
        if (!this.isCompatibleType(keyArgType, keyType)) {
            ctx.addViolation((Node)node, new Object[]{keyArgType.toString(), keyType.toString()});
        } else if (!this.isCompatibleType(valueArgType, valueType)) {
            ctx.addViolation((Node)node, new Object[]{valueArgType.toString(), valueType.toString()});
        }
    }

    private boolean isCollectionType(JClassType type) {
        return TypeTestUtil.isA(Collection.class, (JTypeMirror)type);
    }

    private JTypeMirror getCollectionElementType(JClassType collectionType) {
        JClassType asSuperCollection = collectionType.getAsSuper(collectionType.getTypeSystem().getClassSymbol(Collection.class));
        if (asSuperCollection.getTypeArgs().isEmpty()) {
            return null;
        }
        JTypeMirror elementType = asSuperCollection.getTypeArgs().get(0);
        return this.resolveWildcardBound(elementType);
    }

    private JTypeMirror getMapKeyType(JClassType mapType) {
        JClassType asSuperMap = mapType.getAsSuper(mapType.getTypeSystem().getClassSymbol(Map.class));
        if (asSuperMap.getTypeArgs().isEmpty()) {
            return null;
        }
        JTypeMirror keyType = asSuperMap.getTypeArgs().get(0);
        return this.resolveWildcardBound(keyType);
    }

    private JTypeMirror getMapValueType(JClassType mapType) {
        JClassType asSuperMap = mapType.getAsSuper(mapType.getTypeSystem().getClassSymbol(Map.class));
        if (asSuperMap.getTypeArgs().isEmpty()) {
            return null;
        }
        JTypeMirror valueType = asSuperMap.getTypeArgs().get(1);
        return this.resolveWildcardBound(valueType);
    }

    private JTypeMirror resolveWildcardBound(JTypeMirror type) {
        JWildcardType wildcard;
        if (type instanceof JTypeVar && ((JTypeVar)type).isCaptured() && (wildcard = ((JTypeVar)type).getCapturedOrigin()) != null) {
            return this.resolveWildcard(wildcard, type.getTypeSystem());
        }
        if (type instanceof JWildcardType) {
            return this.resolveWildcard((JWildcardType)type, type.getTypeSystem());
        }
        return type;
    }

    private JTypeMirror resolveWildcard(JWildcardType wildcard, TypeSystem typeSystem) {
        return wildcard.isUpperBound() ? wildcard.asUpperBound() : typeSystem.OBJECT;
    }

    private boolean isCompatibleType(JTypeMirror argType, JTypeMirror expectedType) {
        JTypeMirror rawExpectedType;
        if (TypeOps.isUnresolved(argType)) {
            return true;
        }
        if (argType instanceof JWildcardType || argType instanceof JTypeVar && ((JTypeVar)argType).isCaptured()) {
            return true;
        }
        JTypeMirror rawArgType = this.getRawType(argType);
        if (TypeOps.isConvertible(rawArgType, rawExpectedType = this.getRawType(expectedType)).somehow() || TypeOps.isConvertible(rawExpectedType, rawArgType).somehow()) {
            return true;
        }
        if (argType.isPrimitive()) {
            JTypeMirror boxedArgType = argType.box();
            return TypeOps.isConvertible(boxedArgType, expectedType).somehow();
        }
        return false;
    }

    private JTypeMirror getRawType(JTypeMirror type) {
        if (type instanceof JClassType) {
            JClassType classType = (JClassType)type;
            return classType.getErasure();
        }
        return type;
    }

    private JTypeMirror getQualifierType(ASTMethodCall node) {
        return node.getQualifier() != null ? node.getQualifier().getTypeMirror() : null;
    }

    private ASTExpression getFirstArgument(ASTMethodCall node) {
        return (ASTExpression)node.getArguments().get(0);
    }

    private ASTExpression getSecondArgument(ASTMethodCall node) {
        return (ASTExpression)node.getArguments().get(1);
    }
}

