/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavadocCommentOwner;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.CollectionUtil;

public class CommentRequiredRule
extends AbstractJavaRulechainRule {
    private static final Map<String, String> DESCRIPTOR_NAME_TO_COMMENT_TYPE = new HashMap<String, String>();
    private static final PropertyDescriptor<CommentRequirement> ACCESSOR_CMT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("accessorCommentRequirement", "Comments on getters and setters\"").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final PropertyDescriptor<CommentRequirement> OVERRIDE_CMT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("methodWithOverrideCommentRequirement", "Comments on @Override methods").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final PropertyDescriptor<CommentRequirement> CLASS_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("classCommentRequirement", "Class comments").build();
    private static final PropertyDescriptor<CommentRequirement> FIELD_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("fieldCommentRequirement", "Field comments").build();
    private static final PropertyDescriptor<CommentRequirement> PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("publicMethodCommentRequirement", "Public method and constructor comments").build();
    private static final PropertyDescriptor<CommentRequirement> PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("protectedMethodCommentRequirement", "Protected method constructor comments").build();
    private static final PropertyDescriptor<CommentRequirement> ENUM_CMT_REQUIREMENT_DESCRIPTOR = CommentRequiredRule.requirementPropertyBuilder("enumCommentRequirement", "Enum comments").build();
    private static final PropertyDescriptor<CommentRequirement> SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("serialVersionUIDCommentRequired", "Serial version UID comments").defaultValue((Object)CommentRequirement.Ignored)).build();
    private static final PropertyDescriptor<CommentRequirement> SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)CommentRequiredRule.requirementPropertyBuilder("serialPersistentFieldsCommentRequired", "Serial persistent fields comments").defaultValue((Object)CommentRequirement.Ignored)).build();
    private final Map<PropertyDescriptor<CommentRequirement>, CommentRequirement> propertyValues = new HashMap<PropertyDescriptor<CommentRequirement>, CommentRequirement>();

    public CommentRequiredRule() {
        super(ASTBodyDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(OVERRIDE_CMT_DESCRIPTOR);
        this.definePropertyDescriptor(ACCESSOR_CMT_DESCRIPTOR);
        this.definePropertyDescriptor(CLASS_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
        this.definePropertyDescriptor(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR);
    }

    public void start(RuleContext ctx) {
        this.propertyValues.put(ACCESSOR_CMT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(ACCESSOR_CMT_DESCRIPTOR)));
        this.propertyValues.put(OVERRIDE_CMT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(OVERRIDE_CMT_DESCRIPTOR)));
        this.propertyValues.put(FIELD_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(FIELD_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(ENUM_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(ENUM_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR)));
        this.propertyValues.put(CLASS_CMT_REQUIREMENT_DESCRIPTOR, (CommentRequirement)((Object)this.getProperty(CLASS_CMT_REQUIREMENT_DESCRIPTOR)));
    }

    private void checkCommentMeetsRequirement(Object data, JavadocCommentOwner node, PropertyDescriptor<CommentRequirement> descriptor) {
        switch (this.propertyValues.get(descriptor)) {
            case Ignored: {
                break;
            }
            case Required: {
                if (node.getJavadocComment() != null) break;
                this.commentRequiredViolation(data, node, descriptor);
                break;
            }
            case Unwanted: {
                if (node.getJavadocComment() == null) break;
                this.commentRequiredViolation(data, node, descriptor);
            }
        }
    }

    private void commentRequiredViolation(Object data, JavaNode node, PropertyDescriptor<CommentRequirement> descriptor) {
        this.asCtx(data).addViolationWithMessage((Node)node, DESCRIPTOR_NAME_TO_COMMENT_TYPE.get(descriptor.name()) + " are " + ((CommentRequirement)((Object)this.getProperty(descriptor))).label.toLowerCase(Locale.ROOT));
    }

    public Object visit(ASTClassDeclaration decl, Object data) {
        this.checkCommentMeetsRequirement(data, decl, CLASS_CMT_REQUIREMENT_DESCRIPTOR);
        return data;
    }

    public Object visit(ASTConstructorDeclaration decl, Object data) {
        this.checkMethodOrConstructorComment(decl, data);
        return data;
    }

    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (decl.isOverridden()) {
            this.checkCommentMeetsRequirement(data, decl, OVERRIDE_CMT_DESCRIPTOR);
        } else if (JavaRuleUtil.isGetterOrSetter(decl)) {
            this.checkCommentMeetsRequirement(data, decl, ACCESSOR_CMT_DESCRIPTOR);
        } else {
            this.checkMethodOrConstructorComment(decl, data);
        }
        return data;
    }

    private void checkMethodOrConstructorComment(ASTExecutableDeclaration decl, Object data) {
        if (decl.getVisibility() == ModifierOwner.Visibility.V_PUBLIC) {
            this.checkCommentMeetsRequirement(data, decl, PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        } else if (decl.getVisibility() == ModifierOwner.Visibility.V_PROTECTED) {
            this.checkCommentMeetsRequirement(data, decl, PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR);
        }
    }

    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (JavaRuleUtil.isSerialVersionUID(decl)) {
            this.checkCommentMeetsRequirement(data, decl, SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR);
        } else if (JavaRuleUtil.isSerialPersistentFields(decl)) {
            this.checkCommentMeetsRequirement(data, decl, SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR);
        } else {
            this.checkCommentMeetsRequirement(data, decl, FIELD_CMT_REQUIREMENT_DESCRIPTOR);
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration decl, Object data) {
        this.checkCommentMeetsRequirement(data, decl, ENUM_CMT_REQUIREMENT_DESCRIPTOR);
        return data;
    }

    private boolean allCommentsAreIgnored() {
        return this.getProperty(OVERRIDE_CMT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(ACCESSOR_CMT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(CLASS_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(FIELD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(PUB_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(PROT_METHOD_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(ENUM_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(SERIAL_VERSION_UID_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored && this.getProperty(SERIAL_PERSISTENT_FIELDS_CMT_REQUIREMENT_DESCRIPTOR) == CommentRequirement.Ignored;
    }

    public String dysfunctionReason() {
        return this.allCommentsAreIgnored() ? "All comment types are ignored" : null;
    }

    private static PropertyBuilder.GenericPropertyBuilder<CommentRequirement> requirementPropertyBuilder(String name, String commentType) {
        DESCRIPTOR_NAME_TO_COMMENT_TYPE.put(name, commentType);
        return (PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)name, CommentRequirement.class, cr -> ((CommentRequirement)cr).label).desc(commentType + ". Possible values: " + CollectionUtil.map((Object[])CommentRequirement.values(), cr -> ((CommentRequirement)cr).label))).defaultValue((Object)CommentRequirement.Required);
    }

    private static enum CommentRequirement {
        Required("Required"),
        Ignored("Ignored"),
        Unwanted("Unwanted");

        private final String label;

        private CommentRequirement(String theLabel) {
            this.label = theLabel;
        }
    }
}

