/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.List;
import java.util.function.Predicate;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypingContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ExprMirror {
    public JavaNode getLocation();

    public @Nullable JTypeMirror getStandaloneType();

    default public void finishStandaloneInference(@NonNull JTypeMirror standaloneType) {
    }

    public void setInferredType(JTypeMirror var1);

    public @Nullable JTypeMirror getInferredType();

    public TypingContext getTypingContext();

    default public @NonNull TypeSpecies getStandaloneSpecies() {
        JTypeMirror std = this.getStandaloneType();
        return std == null ? TypeSpecies.UNKNOWN : TypeSpecies.getSpecies(std);
    }

    public boolean isEquivalentToUnderlyingAst();

    default public void groundTree() {
        this.setInferredType(ExprMirror.ensureNoTypeVariables(this.getInferredType()));
    }

    public static JTypeMirror ensureNoTypeVariables(JTypeMirror ty) {
        if (ty == null) {
            return null;
        }
        return ty.subst(InferenceContext.finalGroundSubst());
    }

    public static JMethodSig ensureNoTypeVariables(JMethodSig ty) {
        if (ty == null) {
            return null;
        }
        return ty.subst(InferenceContext.finalGroundSubst());
    }

    public static enum TypeSpecies {
        PRIMITIVE,
        REFERENCE,
        VOID,
        UNKNOWN;


        public static TypeSpecies getSpecies(JTypeMirror t) {
            if (t.isPrimitive()) {
                return PRIMITIVE;
            }
            if (t.isVoid()) {
                return VOID;
            }
            if (TypeOps.isSpecialUnresolved(t)) {
                return UNKNOWN;
            }
            return REFERENCE;
        }
    }

    public static interface CtorInvocationMirror
    extends InvocationMirror {
        public @NonNull JTypeMirror getNewType();

        public boolean isAnonymous();

        public boolean isDiamond();

        @Override
        default public Iterable<JMethodSig> getAccessibleCandidates() {
            return this.getAccessibleCandidates(this.getNewType());
        }

        public Iterable<JMethodSig> getAccessibleCandidates(JTypeMirror var1);

        @Override
        default public String getName() {
            return "new";
        }
    }

    public static interface InvocationMirror
    extends PolyExprMirror,
    MethodUsageMirror {
        public Iterable<JMethodSig> getAccessibleCandidates();

        default public @Nullable JTypeMirror getErasedReceiverType() {
            return null;
        }

        public @Nullable JTypeMirror getReceiverType();

        public List<JTypeMirror> getExplicitTypeArguments();

        public JavaNode getExplicitTargLoc(int var1);

        public String getName();

        public List<ExprMirror> getArgumentExpressions();

        public int getArgumentCount();

        @Override
        public void setCompileTimeDecl(MethodCtDecl var1);

        public @Nullable MethodCtDecl getCtDecl();

        @Override
        default public @Nullable JTypeMirror getTypeToSearch() {
            return this.getReceiverType();
        }

        public static class MethodCtDecl
        implements OverloadSelectionResult {
            private final JMethodSig methodType;
            private final MethodResolutionPhase resolvePhase;
            private final boolean canSkipInvocation;
            private final OptionalBool needsUncheckedConversion;
            private final boolean failed;
            private final @Nullable MethodUsageMirror expr;

            MethodCtDecl(JMethodSig methodType, MethodResolutionPhase resolvePhase, boolean canSkipInvocation, OptionalBool needsUncheckedConversion, boolean failed, @Nullable MethodUsageMirror expr) {
                this.methodType = methodType;
                this.resolvePhase = resolvePhase;
                this.canSkipInvocation = canSkipInvocation;
                this.needsUncheckedConversion = needsUncheckedConversion;
                this.failed = failed;
                this.expr = expr;
            }

            public MethodCtDecl withMethod(JMethodSig method) {
                return this.withMethod(method, this.failed);
            }

            MethodCtDecl withMethod(JMethodSig method, boolean failed) {
                return new MethodCtDecl(method, this.resolvePhase, this.canSkipInvocation, this.needsUncheckedConversion, failed, this.expr);
            }

            public MethodCtDecl withExpr(MethodUsageMirror expr) {
                return new MethodCtDecl(this.methodType, this.resolvePhase, this.canSkipInvocation, this.needsUncheckedConversion, this.failed, expr);
            }

            MethodCtDecl asFailed() {
                return this.withMethod(this.methodType, true);
            }

            boolean canSkipInvocation() {
                return this.canSkipInvocation;
            }

            MethodResolutionPhase getResolvePhase() {
                return this.resolvePhase;
            }

            static MethodCtDecl unresolved(TypeSystem ts) {
                return new MethodCtDecl(ts.UNRESOLVED_METHOD, MethodResolutionPhase.STRICT, true, OptionalBool.UNKNOWN, true, null);
            }

            @Override
            public JMethodSig getMethodType() {
                return this.methodType;
            }

            @Override
            public boolean needsUncheckedConversion() {
                return this.needsUncheckedConversion.isTrue();
            }

            @Override
            public boolean isVarargsCall() {
                return this.resolvePhase.requiresVarargs();
            }

            @Override
            public boolean isFailed() {
                return this.failed;
            }

            public String toString() {
                return "CtDecl[phase=" + (Object)((Object)this.resolvePhase) + ", method=" + this.methodType + ']';
            }

            @Override
            public @Nullable JTypeMirror getTypeToSearch() {
                return this.expr != null ? this.expr.getTypeToSearch() : null;
            }
        }
    }

    public static interface LambdaExprMirror
    extends FunctionalExprMirror {
        public @Nullable List<JTypeMirror> getExplicitParameterTypes();

        default public boolean isExplicitlyTyped() {
            return this.getExplicitParameterTypes() != null;
        }

        public int getParamCount();

        public Iterable<ExprMirror> getResultExpressions();

        public boolean isValueCompatible();

        public boolean isVoidCompatible();

        public void updateTypingContext(List<? extends JTypeMirror> var1);
    }

    public static interface MethodRefMirror
    extends FunctionalExprMirror,
    MethodUsageMirror {
        public boolean isConstructorRef();

        @Override
        public JTypeMirror getTypeToSearch();

        public @Nullable JTypeMirror getLhsIfType();

        public String getMethodName();

        public @NonNull List<JTypeMirror> getExplicitTypeArguments();

        @Override
        public void setCompileTimeDecl(InvocationMirror.MethodCtDecl var1);

        public @Nullable JMethodSig getCachedExactMethod();

        public void setCachedExactMethod(@Nullable JMethodSig var1);
    }

    public static interface MethodUsageMirror
    extends PolyExprMirror {
        public void setCompileTimeDecl(InvocationMirror.MethodCtDecl var1);

        public @Nullable JTypeMirror getTypeToSearch();
    }

    public static interface FunctionalExprMirror
    extends PolyExprMirror {
        @Override
        public void setInferredType(@Nullable JTypeMirror var1);

        public void setFunctionalMethod(@Nullable JMethodSig var1);

        public void finishFailedInference(@Nullable JTypeMirror var1);
    }

    public static interface BranchingMirror
    extends PolyExprMirror {
        public boolean branchesMatch(Predicate<? super ExprMirror> var1);

        default public void setStandalone() {
        }

        @Override
        default public boolean isEquivalentToUnderlyingAst() {
            return this.branchesMatch(ExprMirror::isEquivalentToUnderlyingAst);
        }
    }

    public static interface PolyExprMirror
    extends ExprMirror {
        public @NonNull JClassType getEnclosingType();

        @Override
        default public @Nullable JTypeMirror getStandaloneType() {
            return null;
        }

        default public @Nullable JTypeMirror unresolvedType() {
            return null;
        }
    }
}

