/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symbols.JAccessibleElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.ScopeInfo;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainIterator;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnecessaryImportRule
extends AbstractJavaRule {
    private static final String UNUSED_IMPORT_MESSAGE = "Unused import ''{0}''";
    private static final String UNUSED_STATIC_IMPORT_MESSAGE = "Unused static import ''{0}''";
    private static final String DUPLICATE_IMPORT_MESSAGE = "Duplicate import ''{0}''";
    private static final String IMPORT_FROM_SAME_PACKAGE_MESSAGE = "Unnecessary import from the current package ''{0}''";
    private static final String IMPORT_FROM_JAVA_LANG_MESSAGE = "Unnecessary import from the java.lang package ''{0}''";
    private static final Logger LOG = LoggerFactory.getLogger(UnnecessaryImportRule.class);
    private final Set<ImportWrapper> allSingleNameImports = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> allImportsOnDemand = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> unnecessaryJavaLangImports = new HashSet<ImportWrapper>();
    private final Set<ImportWrapper> unnecessaryImportsFromSamePackage = new HashSet<ImportWrapper>();
    private static final String TYPE_PART_GROUP = "((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?";
    private static final Pattern SEE_PATTERN = Pattern.compile("@see\\s+((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?");
    private static final Pattern LINK_PATTERNS = Pattern.compile("\\{@link(?:plain)?\\s+((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?[\\s\\}]");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\{@value\\s+(\\p{Alpha}\\w*)[\\s#\\}]");
    private static final Pattern THROWS_PATTERN = Pattern.compile("@throws\\s+(\\p{Alpha}\\w*)");
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile("@exception\\s+(\\p{Alpha}\\w*)");
    private static final Pattern LINK_IN_SNIPPET = Pattern.compile("//\\s*@link\\s+(?:.*?)?target=[\"']?((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?[\"']?");
    private static final Pattern[] PATTERNS = new Pattern[]{SEE_PATTERN, LINK_PATTERNS, VALUE_PATTERN, THROWS_PATTERN, EXCEPTION_PATTERN, LINK_IN_SNIPPET};

    public Object visit(ASTCompilationUnit node, Object data) {
        this.allSingleNameImports.clear();
        this.allImportsOnDemand.clear();
        this.unnecessaryJavaLangImports.clear();
        this.unnecessaryImportsFromSamePackage.clear();
        String packageName = node.getPackageName();
        for (ASTImportDeclaration importDecl : node.children(ASTImportDeclaration.class)) {
            this.visitImport(importDecl, data, packageName);
        }
        for (ImportWrapper wrapper : this.allSingleNameImports) {
            if (!"java.lang".equals(wrapper.node.getPackageName()) || this.isJavaLangImportNecessary(node, wrapper)) continue;
            this.unnecessaryJavaLangImports.add(wrapper);
        }
        super.visit(node, data);
        this.visitComments(node);
        this.doReporting(data);
        return data;
    }

    private void doReporting(Object data) {
        String message;
        for (ImportWrapper wrapper : this.allSingleNameImports) {
            message = wrapper.isStatic() ? UNUSED_STATIC_IMPORT_MESSAGE : UNUSED_IMPORT_MESSAGE;
            this.reportWithMessage(wrapper.node, data, message);
        }
        for (ImportWrapper wrapper : this.allImportsOnDemand) {
            message = wrapper.isStatic() ? UNUSED_STATIC_IMPORT_MESSAGE : UNUSED_IMPORT_MESSAGE;
            this.reportWithMessage(wrapper.node, data, message);
        }
        this.unnecessaryJavaLangImports.removeAll(this.allSingleNameImports);
        this.unnecessaryJavaLangImports.removeAll(this.allImportsOnDemand);
        this.unnecessaryImportsFromSamePackage.removeAll(this.allSingleNameImports);
        this.unnecessaryImportsFromSamePackage.removeAll(this.allImportsOnDemand);
        for (ImportWrapper wrapper : this.unnecessaryJavaLangImports) {
            this.reportWithMessage(wrapper.node, data, IMPORT_FROM_JAVA_LANG_MESSAGE);
        }
        for (ImportWrapper wrapper : this.unnecessaryImportsFromSamePackage) {
            this.reportWithMessage(wrapper.node, data, IMPORT_FROM_SAME_PACKAGE_MESSAGE);
        }
    }

    private boolean isJavaLangImportNecessary(ASTCompilationUnit node, ImportWrapper wrapper) {
        ShadowChainIterator<JTypeMirror, ScopeInfo> iter = node.getSymbolTable().types().iterateResults(wrapper.node.getImportedSimpleName());
        if (iter.hasNext()) {
            iter.next();
            if (iter.getScopeTag() == ScopeInfo.SINGLE_IMPORT && iter.hasNext()) {
                iter.next();
                return iter.getScopeTag() != ScopeInfo.JAVA_LANG;
            }
        }
        return false;
    }

    private void visitComments(ASTCompilationUnit node) {
        for (JavaComment comment : node.getComments()) {
            if (!(comment instanceof JavadocComment)) continue;
            for (Pattern p : PATTERNS) {
                Matcher m = p.matcher((CharSequence)comment.getText());
                while (m.find()) {
                    String fullname = m.group(1);
                    if (fullname != null) {
                        this.removeReferenceSingleImport(fullname);
                    }
                    if (m.groupCount() > 1 && (fullname = m.group(2)) != null) {
                        for (String param : fullname.split("\\s*,\\s*")) {
                            this.removeReferenceSingleImport(param);
                        }
                    }
                    if (!this.allSingleNameImports.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    private void visitImport(ASTImportDeclaration node, Object data, String thisPackageName) {
        Set<ImportWrapper> container;
        if (thisPackageName.equals(node.getPackageName())) {
            this.unnecessaryImportsFromSamePackage.add(new ImportWrapper(node));
        }
        Set<ImportWrapper> set = container = node.isImportOnDemand() ? this.allImportsOnDemand : this.allSingleNameImports;
        if (!container.add(new ImportWrapper(node))) {
            this.reportWithMessage(node, data, DUPLICATE_IMPORT_MESSAGE);
        }
    }

    private void reportWithMessage(ASTImportDeclaration node, Object data, String message) {
        this.asCtx(data).addViolationWithMessage((Node)node, message, new Object[]{PrettyPrintingUtil.prettyImport(node)});
    }

    public Object visit(ASTClassType node, Object data) {
        if (node.getQualifier() == null && !node.isFullyQualified() && node.getTypeMirror().isClassOrInterface()) {
            JClassSymbol symbol = ((JClassType)node.getTypeMirror()).getSymbol();
            ShadowChainIterator<JTypeMirror, ScopeInfo> scopeIter = node.getSymbolTable().types().iterateResults(node.getSimpleName());
            this.checkScopeChain(false, symbol, scopeIter, ts -> true, false);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTAmbiguousName node, Object data) {
        boolean onlyStatic = !(node.getParent() instanceof ASTClassType);
        this.recordFailedTypeResWithName(node, node.getFirstToken().getImage(), onlyStatic);
        return null;
    }

    private void recordFailedTypeResWithName(JavaNode location, String name, boolean onlyStatics) {
        String target = onlyStatics ? "static " : "";
        LOG.debug("UnnecessaryImport: Failed type res for {} will cause all {}imports named {} to be marked as used", new Object[]{location, target, name});
        boolean foundNamedImport = this.allSingleNameImports.removeIf(decl -> (!onlyStatics || ((ImportWrapper)decl).isStatic()) && name.equals(((ImportWrapper)decl).node.getImportedSimpleName()));
        if (!foundNamedImport) {
            LOG.debug("+ Since no such named import can be found, all {}on-demand-imports will be marked as used", (Object)target);
            this.allImportsOnDemand.removeIf(it -> !onlyStatics || ((ImportWrapper)it).isStatic());
        }
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (node.getQualifier() == null) {
            OverloadSelectionResult overload = node.getOverloadSelectionInfo();
            if (overload.isFailed()) {
                this.recordFailedTypeResWithName(node, node.getMethodName(), true);
                return super.visit(node, data);
            }
            ShadowChainIterator<JMethodSig, ScopeInfo> scopeIter = node.getSymbolTable().methods().iterateResults(node.getMethodName());
            JExecutableSymbol symbol = overload.getMethodType().getSymbol();
            this.checkScopeChain(true, symbol, scopeIter, methods -> CollectionUtil.any((Iterable)methods, m -> m.getSymbol().equals(symbol)), true);
        }
        return super.visit(node, data);
    }

    public Object visit(ASTVariableAccess node, Object data) {
        JVariableSymbol sym = node.getReferencedSym();
        if (sym != null && sym.isField() && ((JFieldSymbol)sym).isStatic()) {
            if (node.getParent() instanceof ASTSwitchLabel && node.ancestors(ASTSwitchLike.class).take(1).any(ASTSwitchLike::isEnumSwitch)) {
                return null;
            }
            ShadowChainIterator<JVariableSig, ScopeInfo> scopeIter = node.getSymbolTable().variables().iterateResults(node.getName());
            this.checkScopeChain(false, (JFieldSymbol)sym, scopeIter, ts -> true, true);
        }
        if (sym == null) {
            this.recordFailedTypeResWithName(node, node.getName(), true);
        }
        return null;
    }

    private <T> void checkScopeChain(boolean recursive, JAccessibleElementSymbol symbol, ShadowChainIterator<T, ScopeInfo> scopeIter, Predicate<List<T>> containsTarget, boolean onlyStatic) {
        while (scopeIter.hasNext()) {
            scopeIter.next();
            if (containsTarget.test(scopeIter.getResults())) {
                if (scopeIter.getScopeTag() == ScopeInfo.SINGLE_IMPORT) {
                    this.allSingleNameImports.removeIf(it -> (((ImportWrapper)it).isStatic() || !onlyStatic) && symbol.getSimpleName().equals(((ImportWrapper)it).node.getImportedSimpleName()));
                } else if (scopeIter.getScopeTag() == ScopeInfo.IMPORT_ON_DEMAND) {
                    this.allImportsOnDemand.removeIf(it -> {
                        if (!((ImportWrapper)it).isStatic() && onlyStatic) {
                            return false;
                        }
                        JClassSymbol symbolOwner = symbol.getEnclosingClass();
                        if (symbolOwner == null) {
                            return ((ImportWrapper)it).node.getImportedName().equals(symbol.getPackageName());
                        }
                        if (((ImportWrapper)it).node.getImportedName().equals(symbolOwner.getCanonicalName())) {
                            return ((ImportWrapper)it).isStatic() == symbol.isStatic();
                        }
                        TypeSystem ts = symbolOwner.getTypeSystem();
                        JClassSymbol importedContainer = ts.getClassSymbol(((ImportWrapper)it).node.getImportedName());
                        return importedContainer == null || TypeTestUtil.isA(ts.rawType(symbolOwner), ts.rawType(importedContainer));
                    });
                }
                return;
            }
            if (recursive) continue;
            break;
        }
    }

    private void removeReferenceSingleImport(String referenceName) {
        String expectedImport = StringUtils.substringBefore((String)referenceName, (String)".");
        this.allSingleNameImports.removeIf(it -> expectedImport.equals(((ImportWrapper)it).node.getImportedSimpleName()));
    }

    private static final class ImportWrapper {
        private final ASTImportDeclaration node;

        private ImportWrapper(ASTImportDeclaration node) {
            this.node = node;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            ImportWrapper that = (ImportWrapper)o;
            return this.node.getImportedName().equals(that.node.getImportedName()) && this.node.isImportOnDemand() == that.node.isImportOnDemand() && this.isStatic() == that.isStatic();
        }

        public int hashCode() {
            return this.node.getImportedName().hashCode() * 31 + Boolean.hashCode(this.node.isStatic()) + 37 * Boolean.hashCode(this.node.isImportOnDemand());
        }

        private boolean isStatic() {
            return this.node.isStatic();
        }
    }
}

