/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodResolutionPhase;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailure;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TypeInferenceLogger {
    default public void polyResolutionFailure(JavaNode node) {
    }

    default public void noApplicableCandidates(MethodCallSite site) {
    }

    default public void noCompileTimeDeclaration(MethodCallSite site) {
    }

    default public void startInference(JMethodSig sig, MethodCallSite site, MethodResolutionPhase phase) {
    }

    default public void endInference(@Nullable JMethodSig result) {
    }

    default public void fallbackInvocation(JMethodSig ctdecl, MethodCallSite site) {
    }

    default public void skipInstantiation(JMethodSig partiallyInferred, MethodCallSite site) {
    }

    default public void ambiguityError(MethodCallSite site, @Nullable ExprMirror.InvocationMirror.MethodCtDecl selected, List<ExprMirror.InvocationMirror.MethodCtDecl> m1) {
    }

    default public void ctxInitialization(InferenceContext ctx, JMethodSig sig) {
    }

    default public void applicabilityTest(InferenceContext ctx, JMethodSig sig) {
    }

    default public void startArgsChecks() {
    }

    default public void startArg(int i, ExprMirror expr, JTypeMirror formal) {
    }

    default public void skipArgAsNonPertinent(int i, ExprMirror expr) {
    }

    default public void functionalExprNeedsInvocationCtx(JTypeMirror targetT, ExprMirror expr) {
    }

    default public void endArg() {
    }

    default public void endArgsChecks() {
    }

    default public void startReturnChecks() {
    }

    default public void endReturnChecks() {
    }

    default public void propagateAndAbort(InferenceContext context, InferenceContext parent) {
    }

    default public void boundAdded(InferenceContext ctx, InferenceVar var, InferenceVar.BoundKind kind, JTypeMirror bound, boolean isSubstitution) {
    }

    default public void ivarMerged(InferenceContext ctx, InferenceVar var, InferenceVar delegate) {
    }

    default public void ivarInstantiated(InferenceContext ctx, InferenceVar var, JTypeMirror inst) {
    }

    default public void logResolutionFail(ResolutionFailure exception) {
    }

    default public boolean isNoop() {
        return false;
    }

    public TypeInferenceLogger newInstance();

    public static TypeInferenceLogger noop() {
        return SimpleLogger.NOOP;
    }

    public static class VerboseLogger
    extends SimpleLogger {
        private final Deque<Integer> marks = new ArrayDeque<Integer>();

        public VerboseLogger(PrintStream out) {
            super(out);
            this.mark();
        }

        void mark() {
            this.marks.push(this.getLevel());
        }

        void rollback(String lastWords) {
            int pop = this.marks.pop();
            this.updateLevel(pop - this.getLevel());
            if (!lastWords.isEmpty()) {
                this.updateLevel(4);
                this.println(lastWords);
                this.updateLevel(-4);
            }
        }

        @Override
        public void startInference(JMethodSig sig, MethodCallSite site, MethodResolutionPhase phase) {
            this.mark();
            this.startSection(String.format("Phase %-17s%s", new Object[]{phase, this.ppHighlight(sig)}));
        }

        @Override
        public void ctxInitialization(InferenceContext ctx, JMethodSig sig) {
            this.println(String.format("Context %-11d%s", ctx.getId(), this.ppHighlight(ctx.mapToIVars(sig))));
        }

        @Override
        public void applicabilityTest(InferenceContext ctx, JMethodSig sig) {
            this.println(String.format("Applicability testing with Context %-11d%s", ctx.getId(), this.ppHighlight(ctx.mapToIVars(sig))));
        }

        @Override
        public void endInference(@Nullable JMethodSig result) {
            this.rollback(result != null ? "Success: " + this.ppHighlight(result) : "FAILED! SAD!");
        }

        @Override
        public void skipInstantiation(JMethodSig partiallyInferred, MethodCallSite site) {
            this.println("Skipping instantiation of " + partiallyInferred + ", it's already complete");
        }

        @Override
        public void startArgsChecks() {
            this.startSection("ARGUMENTS");
        }

        @Override
        public void startReturnChecks() {
            this.startSection("RETURN");
        }

        @Override
        public void propagateAndAbort(InferenceContext context, InferenceContext parent) {
            this.println("Ctx " + parent.getId() + " adopts " + this.color(context.getFreeVars(), "\u001b[34m") + " from ctx " + context.getId());
        }

        @Override
        public void startArg(int i, ExprMirror expr, JTypeMirror formalType) {
            this.startSection("Checking arg " + i + " against " + formalType);
            this.printExpr(expr);
        }

        @Override
        public void skipArgAsNonPertinent(int i, ExprMirror expr) {
            this.startSection("Argument " + i + " is not pertinent to applicability");
            this.printExpr(expr);
            this.endSection("");
        }

        @Override
        public void functionalExprNeedsInvocationCtx(JTypeMirror targetT, ExprMirror expr) {
            this.println("Target type is not a functional interface yet: " + targetT);
            this.println("Will wait for invocation phase before discarding.");
        }

        @Override
        public void endArgsChecks() {
            this.endSection("");
        }

        @Override
        public void endArg() {
            this.endSection("");
        }

        @Override
        public void endReturnChecks() {
            this.endSection("");
        }

        @Override
        public void boundAdded(InferenceContext ctx, InferenceVar ivar, InferenceVar.BoundKind kind, JTypeMirror bound, boolean isSubstitution) {
            String message = isSubstitution ? "Changed bound" : "New bound";
            this.println(this.addCtxInfo(ctx, message) + this.ppBound(ivar, kind, bound));
        }

        @Override
        public void ivarMerged(InferenceContext ctx, InferenceVar var, InferenceVar delegate) {
            this.println(this.addCtxInfo(ctx, "Ivar merged") + var + " <=> " + delegate);
        }

        @Override
        public void ivarInstantiated(InferenceContext ctx, InferenceVar var, JTypeMirror inst) {
            this.println(this.addCtxInfo(ctx, "Ivar instantiated") + this.color(var + " := ", "\u001b[34m") + VerboseLogger.colorIvars(inst));
        }

        private @NonNull String addCtxInfo(InferenceContext ctx, String event) {
            return String.format("%-20s(ctx %d):   ", event, ctx.getId());
        }

        @Override
        public void logResolutionFail(ResolutionFailure exception) {
            super.logResolutionFail(exception);
            this.println("Failed: " + exception.getReason());
        }

        @Override
        public TypeInferenceLogger newInstance() {
            return new VerboseLogger(this.out);
        }
    }

    public static class SimpleLogger
    implements TypeInferenceLogger {
        static final TypeInferenceLogger NOOP = new TypeInferenceLogger(){

            @Override
            public boolean isNoop() {
                return true;
            }

            @Override
            public TypeInferenceLogger newInstance() {
                return this;
            }
        };
        protected final PrintStream out;
        protected static final int LEVEL_INCREMENT = 4;
        private int level;
        private String indent;
        protected static final String ANSI_RESET = "\u001b[0m";
        protected static final String ANSI_BLUE = "\u001b[34m";
        protected static final String ANSI_PURPLE = "\u001b[35m";
        protected static final String ANSI_GRAY = "\u001b[37m";
        protected static final String ANSI_RED = "\u001b[31m";
        protected static final String ANSI_YELLOW = "\u001b[33m";
        private static final String TO_BLUE = Matcher.quoteReplacement("\u001b[34m") + "$0" + Matcher.quoteReplacement("\u001b[0m");
        private static final String TO_WHITE = Matcher.quoteReplacement("\u001b[37m") + "$0" + Matcher.quoteReplacement("\u001b[0m");
        private static final Pattern IVAR_PATTERN = Pattern.compile("['^][\u03b1-\u03c9a-z]\\d*");
        private static final Pattern IDENT_PATTERN = Pattern.compile("\\b(?<!['^])(?!extends|super|capture|of|)[\\w]++(?!\\.)<?|-?>++");

        protected String color(Object str, String color) {
            return SystemUtils.IS_OS_UNIX ? color + str + ANSI_RESET : str.toString();
        }

        protected static String colorIvars(Object str) {
            return SimpleLogger.doColor(str, IVAR_PATTERN, TO_BLUE);
        }

        protected static String colorPunct(Object str) {
            return SimpleLogger.doColor(str, IDENT_PATTERN, TO_WHITE);
        }

        protected static String doColor(Object str, Pattern pattern, String replacement) {
            if (SystemUtils.IS_OS_UNIX) {
                return pattern.matcher(str.toString()).replaceAll(replacement);
            }
            return str.toString();
        }

        public SimpleLogger(PrintStream out) {
            this.out = out;
            this.updateLevel(0);
        }

        protected int getLevel() {
            return this.level;
        }

        protected void updateLevel(int increment) {
            this.level += increment;
            this.indent = StringUtils.repeat((char)' ', (int)this.level);
        }

        protected void println(String str) {
            this.out.print(this.indent);
            this.out.println(str);
        }

        protected void endSection(String footer) {
            this.updateLevel(-4);
            this.println(footer);
        }

        protected void startSection(String header) {
            this.println(header);
            this.updateLevel(4);
        }

        @Override
        public void logResolutionFail(ResolutionFailure exception) {
            if (exception.getCallSite() instanceof MethodCallSite && exception != ResolutionFailure.UNKNOWN) {
                ((MethodCallSite)exception.getCallSite()).acceptFailure(exception);
            }
        }

        @Override
        public void noApplicableCandidates(MethodCallSite site) {
            JTypeDeclSymbol symbol;
            if (!site.isLogEnabled()) {
                return;
            }
            @Nullable JTypeMirror receiver = ((ExprMirror.InvocationMirror)site.getExpr()).getErasedReceiverType();
            if (receiver != null && ((symbol = receiver.getSymbol()) == null || symbol.isUnresolved())) {
                return;
            }
            if (site.getExpr() instanceof ExprMirror.CtorInvocationMirror) {
                this.startSection("[WARNING] No potentially applicable constructors in " + ((ExprMirror.CtorInvocationMirror)site.getExpr()).getNewType());
            } else {
                this.startSection("[WARNING] No potentially applicable methods in " + receiver);
            }
            this.printExpr((ExprMirror)site.getExpr());
            Iterator<JMethodSig> iter = ((ExprMirror.InvocationMirror)site.getExpr()).getAccessibleCandidates().iterator();
            if (iter.hasNext()) {
                this.startSection("Accessible signatures:");
                iter.forEachRemaining(it -> this.println(this.ppMethod((JMethodSig)it)));
                this.endSection("");
            } else {
                this.println("No accessible signatures");
            }
            this.endSection("");
        }

        @Override
        public void noCompileTimeDeclaration(MethodCallSite site) {
            if (!site.isLogEnabled()) {
                return;
            }
            this.startSection("[WARNING] Compile-time declaration resolution failed.");
            this.printExpr((ExprMirror)site.getExpr());
            this.summarizeFailures(site);
            this.endSection("");
        }

        private void summarizeFailures(MethodCallSite site) {
            this.startSection("Summary of failures:");
            site.getResolutionFailures().forEach((phase, failures) -> {
                this.startSection(phase.toString() + ":");
                failures.forEach(it -> this.println(String.format("%-64s // while checking %s", it.getReason(), this.ppMethod(it.getFailedMethod()))));
                this.endSection("");
            });
            this.endSection("");
        }

        @Override
        public void fallbackInvocation(JMethodSig ctdecl, MethodCallSite site) {
            if (!site.isLogEnabled()) {
                return;
            }
            this.startSection("[WARNING] Invocation type resolution failed");
            this.printExpr((ExprMirror)site.getExpr());
            this.summarizeFailures(site);
            this.println("-> Falling back on " + this.ppHighlight(ctdecl) + " (this may cause future mistakes)");
            this.endSection("");
        }

        @Override
        public void ambiguityError(MethodCallSite site, @Nullable ExprMirror.InvocationMirror.MethodCtDecl selected, List<ExprMirror.InvocationMirror.MethodCtDecl> methods) {
            this.println("");
            this.printExpr((ExprMirror)site.getExpr());
            this.startSection("[WARNING] Ambiguity error: all methods are maximally specific");
            for (ExprMirror.InvocationMirror.MethodCtDecl m : methods) {
                this.println(this.color(InternalMethodTypeItf.cast(m.getMethodType()).originalMethod(), ANSI_RED));
            }
            if (selected != null) {
                this.endSection("Will select " + this.color(InternalMethodTypeItf.cast(selected.getMethodType()).originalMethod(), ANSI_BLUE));
            } else {
                this.endSection("");
            }
        }

        protected void printExpr(ExprMirror expr) {
            String exprText = expr.getLocation().getText().toString();
            exprText = exprText.replaceAll("\\R\\s+", "");
            exprText = StringUtil.escapeJava((String)StringUtils.truncate((String)exprText, (int)100));
            this.println("At:   " + this.fileLocation(expr));
            this.println("Expr: " + this.color(exprText, ANSI_YELLOW));
        }

        private String fileLocation(ExprMirror mirror) {
            return mirror.getLocation().getReportLocation().startPosToStringWithFile();
        }

        protected @NonNull String ppMethod(JMethodSig sig) {
            return TypePrettyPrint.prettyPrint(sig, new TypePrettyPrint.TypePrettyPrinter().printMethodHeader(false));
        }

        protected @NonNull String ppHighlight(JMethodSig sig) {
            String s = this.ppMethod(sig);
            int paramStart = s.indexOf(40);
            String name = s.substring(0, paramStart);
            String rest = s.substring(paramStart);
            return this.color(name, ANSI_BLUE) + SimpleLogger.colorIvars(SimpleLogger.colorPunct(rest));
        }

        protected @NonNull String ppBound(InferenceVar ivar, InferenceVar.BoundKind kind, JTypeMirror bound) {
            return ivar + kind.getSym() + SimpleLogger.colorIvars(SimpleLogger.colorPunct(bound));
        }

        @Override
        public TypeInferenceLogger newInstance() {
            return new SimpleLogger(this.out);
        }
    }
}

