/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponentList;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.AbstractInvocationExpr;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.AbstractTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.AstDisambiguationPass;
import net.sourceforge.pmd.lang.java.ast.CommentAssignmentPass;
import net.sourceforge.pmd.lang.java.ast.FunctionalExpression;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaTokenDocumentBehavior;
import net.sourceforge.pmd.lang.java.ast.OverrideResolutionPass;
import net.sourceforge.pmd.lang.java.ast.SymbolDeclaratorNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.TypesFromAst;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JRecordComponentSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.internal.ReferenceCtx;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.lang.java.types.ast.internal.LazyTypeResolver;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
public final class InternalApiBridge {
    private InternalApiBridge() {
    }

    public static void setSymbol(SymbolDeclaratorNode node, JElementSymbol symbol) {
        if (node instanceof ASTMethodDeclaration) {
            ((ASTMethodDeclaration)node).setSymbol((JMethodSymbol)symbol);
        } else if (node instanceof ASTConstructorDeclaration) {
            ((ASTConstructorDeclaration)node).setSymbol((JConstructorSymbol)symbol);
        } else if (node instanceof ASTTypeDeclaration) {
            ((AbstractTypeDeclaration)node).setSymbol((JClassSymbol)symbol);
        } else if (node instanceof ASTVariableId) {
            ((ASTVariableId)node).setSymbol((JVariableSymbol)symbol);
        } else if (node instanceof ASTTypeParameter) {
            ((ASTTypeParameter)node).setSymbol((JTypeParameterSymbol)symbol);
        } else if (node instanceof ASTRecordComponentList) {
            ((ASTRecordComponentList)node).setSymbol((JConstructorSymbol)symbol);
        } else if (node instanceof ASTRecordComponent) {
            ((ASTRecordComponent)node).setSymbol((JRecordComponentSymbol)symbol);
        } else {
            throw new AssertionError((Object)("Cannot set symbol " + symbol + " on node " + node));
        }
    }

    public static void disambigWithCtx(NodeStream<? extends JavaNode> nodes, ReferenceCtx ctx) {
        AstDisambiguationPass.disambigWithCtx(nodes, ctx);
    }

    public static void forceTypeResolutionPhase(JavaAstProcessor processor, ASTCompilationUnit root) {
        root.descendants(TypeNode.class).crossFindBoundaries().forEach(it -> {
            try {
                it.getTypeMirror();
            }
            catch (Exception e) {
                processor.getLogger().warning((Node)it, "Error during type resolution of node " + it.getXPathNodeName(), new Object[0]);
            }
        });
    }

    public static void usageResolution(JavaAstProcessor processor, ASTCompilationUnit root) {
        root.descendants(ASTAssignableExpr.ASTNamedReferenceExpr.class).crossFindBoundaries().forEach(node -> {
            ASTVariableId reffed;
            JVariableSymbol sym = node.getReferencedSym();
            if (sym != null && (reffed = (ASTVariableId)sym.tryGetNode()) != null) {
                reffed.addUsage((ASTAssignableExpr.ASTNamedReferenceExpr)node);
            }
        });
    }

    public static void overrideResolution(JavaAstProcessor processor, ASTCompilationUnit root) {
        root.descendants(ASTTypeDeclaration.class).crossFindBoundaries().forEach(OverrideResolutionPass::resolveOverrides);
    }

    public static @Nullable JTypeMirror getTypeMirrorInternal(TypeNode node) {
        return ((AbstractJavaTypeNode)node).getTypeMirrorInternal();
    }

    public static void setTypeMirrorInternal(TypeNode node, JTypeMirror inferred) {
        ((AbstractJavaTypeNode)node).setTypeMirror(inferred);
    }

    public static void setSignature(ASTFieldAccess node, JVariableSig.FieldSig sig) {
        node.setTypedSym(sig);
    }

    public static void setSignature(ASTVariableAccess node, JVariableSig sig) {
        node.setTypedSym(sig);
    }

    public static void setFunctionalMethod(FunctionalExpression node, JMethodSig methodType) {
        if (node instanceof ASTMethodReference) {
            ((ASTMethodReference)node).setFunctionalMethod(methodType);
        } else if (node instanceof ASTLambdaExpression) {
            ((ASTLambdaExpression)node).setFunctionalMethod(methodType);
        } else {
            throw AssertionUtil.shouldNotReachHere((String)("FunctionalExpression is not handled: " + node));
        }
    }

    public static void setCompileTimeDecl(ASTMethodReference methodReference, JMethodSig methodType) {
        methodReference.setCompileTimeDecl(methodType);
    }

    public static void initTypeResolver(ASTCompilationUnit acu, JavaAstProcessor processor, TypeInferenceLogger logger) {
        acu.setTypeResolver(new LazyTypeResolver(processor, logger));
    }

    public static void setOverload(InvocationNode expression, OverloadSelectionResult result) {
        if (expression instanceof AbstractInvocationExpr) {
            ((AbstractInvocationExpr)expression).setOverload(result);
        } else if (expression instanceof ASTExplicitConstructorInvocation) {
            ((ASTExplicitConstructorInvocation)expression).setOverload(result);
        } else if (expression instanceof ASTEnumConstant) {
            ((ASTEnumConstant)expression).setOverload(result);
        } else {
            throw new IllegalArgumentException("Wrong type: " + expression);
        }
    }

    public static JavaAstProcessor getProcessor(JavaNode n) {
        return n.getRoot().getLazyTypeResolver().getProcessor();
    }

    public static Infer getInferenceEntryPoint(JavaNode n) {
        return n.getRoot().getLazyTypeResolver().getInfer();
    }

    public static @NonNull LazyTypeResolver getLazyTypeResolver(JavaNode n) {
        return n.getRoot().getLazyTypeResolver();
    }

    public static @NonNull ExprContext getTopLevelExprContext(TypeNode n) {
        return n.getRoot().getLazyTypeResolver().getTopLevelContextIncludingInvocation(n);
    }

    public static void setSymbolTable(JavaNode node, JSymbolTable table) {
        ((AbstractJavaNode)node).setSymbolTable(table);
    }

    public static void setQname(ASTTypeDeclaration declaration, String binaryName, @Nullable String canon) {
        ((AbstractTypeDeclaration)declaration).setBinaryName(binaryName, canon);
    }

    public static void assignComments(ASTCompilationUnit root) {
        CommentAssignmentPass.assignCommentsToDeclarations(root);
    }

    public static JavaccTokenDocument.TokenDocumentBehavior javaTokenDoc() {
        return JavaTokenDocumentBehavior.INSTANCE;
    }

    public static void setStandaloneTernary(ASTConditionalExpression node) {
        node.setStandaloneTernary();
    }

    public static boolean isStandaloneInternal(ASTConditionalExpression node) {
        return node.isStandalone();
    }

    public static JTypeMirror buildTypeFromAstInternal(TypeSystem ts, Substitution lexicalSubst, ASTType node) {
        return TypesFromAst.fromAst(ts, lexicalSubst, node);
    }

    public static JTypeDeclSymbol getReferencedSym(ASTClassType type) {
        return type.getReferencedSym();
    }

    public static void setTypedSym(ASTFieldAccess expr, JVariableSig.FieldSig sym) {
        expr.setTypedSym(sym);
    }

    public static void setTypedSym(ASTVariableAccess expr, JVariableSig sym) {
        expr.setTypedSym(sym);
    }
}

