/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.symbols.BoundToNode;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JRecordComponentSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolVisitor;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.Substitution;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public interface JClassSymbol
extends JTypeDeclSymbol,
JTypeParameterOwnerSymbol,
BoundToNode<ASTTypeDeclaration> {
    public @NonNull String getBinaryName();

    public @Nullable String getCanonicalName();

    public @Nullable JExecutableSymbol getEnclosingMethod();

    @Override
    default public JTypeParameterOwnerSymbol getEnclosingTypeParameterOwner() {
        JExecutableSymbol enclosingMethod = this.getEnclosingMethod();
        return enclosingMethod != null ? enclosingMethod : this.getEnclosingClass();
    }

    public List<JClassSymbol> getDeclaredClasses();

    default public @Nullable JClassSymbol getDeclaredClass(String name) {
        for (JClassSymbol klass : this.getDeclaredClasses()) {
            if (!klass.nameEquals(name)) continue;
            return klass;
        }
        return null;
    }

    public List<JMethodSymbol> getDeclaredMethods();

    public List<JConstructorSymbol> getConstructors();

    public List<JFieldSymbol> getDeclaredFields();

    default public @Nullable JFieldSymbol getDeclaredField(String name) {
        for (JFieldSymbol field : this.getDeclaredFields()) {
            if (!field.nameEquals(name)) continue;
            return field;
        }
        return null;
    }

    default public @NonNull List<JFieldSymbol> getEnumConstants() {
        return Collections.emptyList();
    }

    default public @NonNull List<JRecordComponentSymbol> getRecordComponents() {
        return Collections.emptyList();
    }

    public List<JClassType> getSuperInterfaceTypes(Substitution var1);

    public @Nullable JClassType getSuperclassType(Substitution var1);

    public @Nullable JClassSymbol getSuperclass();

    public List<JClassSymbol> getSuperInterfaces();

    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public @Nullable JTypeDeclSymbol getArrayComponent();

    public boolean isArray();

    public boolean isPrimitive();

    public boolean isEnum();

    public boolean isRecord();

    public boolean isAnnotation();

    public boolean isLocalClass();

    public boolean isAnonymousClass();

    default public PSet<String> getAnnotationAttributeNames() {
        return HashTreePSet.empty();
    }

    default public @Nullable SymbolicValue getDefaultAnnotationAttributeValue(String attrName) {
        if (!this.isAnnotation()) {
            return null;
        }
        for (JMethodSymbol m : this.getDeclaredMethods()) {
            if (!m.nameEquals(attrName) || !m.isAnnotationAttribute()) continue;
            return m.getDefaultAnnotationValue();
        }
        return null;
    }

    default public @Nullable RetentionPolicy getAnnotationRetention() {
        if (!this.isAnnotation()) {
            return null;
        }
        return Optional.ofNullable(this.getDeclaredAnnotation(Retention.class)).map(annot -> annot.getAttribute("value")).filter(value -> value instanceof SymbolicValue.SymEnum).map(value -> ((SymbolicValue.SymEnum)value).toEnum(RetentionPolicy.class)).orElse(RetentionPolicy.CLASS);
    }

    default public boolean annotationAppliesTo(ElementType elementType) {
        if (!this.isAnnotation()) {
            return false;
        }
        SymbolicValue.SymAnnot target = this.getDeclaredAnnotation(Target.class);
        if (target == null) {
            return elementType != ElementType.TYPE_PARAMETER;
        }
        return target.attributeContains("value", (Object)elementType).isTrue();
    }

    default public boolean isClass() {
        return !this.isInterface() && !this.isArray() && !this.isPrimitive();
    }

    default public @NonNull JClassSymbol getNestRoot() {
        JClassSymbol e = this;
        while (e.getEnclosingClass() != null) {
            e = e.getEnclosingClass();
        }
        return e;
    }

    @Override
    default public <R, P> R acceptVisitor(SymbolVisitor<R, P> visitor, P param) {
        return visitor.visitClass(this, param);
    }
}

