/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JConstructorSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolVisitor;
import net.sourceforge.pmd.lang.java.symbols.internal.ImplicitMemberSymbols;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ArraySymbolImpl
implements JClassSymbol {
    private static final int COMPONENT_MOD_MASK = 7;
    private final TypeSystem ts;
    private final JTypeDeclSymbol component;

    ArraySymbolImpl(TypeSystem ts, JTypeDeclSymbol component) {
        this.component = Objects.requireNonNull(component, "Array symbol requires component");
        this.ts = Objects.requireNonNull(ts, "Array symbol requires symbol factory");
        if (component instanceof JClassSymbol && ((JClassSymbol)component).isAnonymousClass()) {
            throw new IllegalArgumentException("Anonymous classes cannot be array components: " + component);
        }
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public @NonNull String getBinaryName() {
        if (this.component instanceof JClassSymbol) {
            return ((JClassSymbol)this.component).getBinaryName() + "[]";
        }
        return this.component.getSimpleName() + "[]";
    }

    @Override
    public String getCanonicalName() {
        if (this.component instanceof JClassSymbol) {
            String compName = ((JClassSymbol)this.component).getCanonicalName();
            return compName == null ? null : compName + "[]";
        }
        return this.component.getSimpleName() + "[]";
    }

    @Override
    public boolean isUnresolved() {
        return false;
    }

    @Override
    public @Nullable JExecutableSymbol getEnclosingMethod() {
        return null;
    }

    @Override
    public List<JMethodSymbol> getDeclaredMethods() {
        return Collections.singletonList(ImplicitMemberSymbols.arrayClone(this));
    }

    @Override
    public List<JFieldSymbol> getDeclaredFields() {
        return Collections.singletonList(ImplicitMemberSymbols.arrayLengthField(this));
    }

    @Override
    public @Nullable JClassSymbol getSuperclass() {
        return this.getTypeSystem().OBJECT.getSymbol();
    }

    @Override
    public List<JClassSymbol> getSuperInterfaces() {
        return CollectionUtil.listOf((Object)this.getTypeSystem().CLONEABLE.getSymbol(), (Object[])new JClassSymbol[]{this.getTypeSystem().SERIALIZABLE.getSymbol()});
    }

    @Override
    public List<JClassType> getSuperInterfaceTypes(Substitution substitution) {
        return CollectionUtil.listOf((Object)this.getTypeSystem().CLONEABLE, (Object[])new JClassType[]{this.getTypeSystem().SERIALIZABLE});
    }

    @Override
    public @Nullable JClassType getSuperclassType(Substitution substitution) {
        return this.getTypeSystem().OBJECT;
    }

    @Override
    public @NonNull JTypeDeclSymbol getArrayComponent() {
        return this.component;
    }

    @Override
    public <R, P> R acceptVisitor(SymbolVisitor<R, P> visitor, P param) {
        return visitor.visitArray(this, this.component, param);
    }

    @Override
    public boolean equals(Object o) {
        return SymbolEquality.equals(this, o);
    }

    public int hashCode() {
        return SymbolEquality.hash(this);
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public List<JClassSymbol> getDeclaredClasses() {
        return Collections.emptyList();
    }

    @Override
    public List<JConstructorSymbol> getConstructors() {
        return Collections.singletonList(ImplicitMemberSymbols.arrayConstructor(this));
    }

    @Override
    public @NonNull String getPackageName() {
        return this.getArrayComponent().getPackageName();
    }

    @Override
    public @NonNull String getSimpleName() {
        return this.getArrayComponent().getSimpleName() + "[]";
    }

    @Override
    public int getModifiers() {
        int comp = this.getArrayComponent().getModifiers() & 7;
        return 0x410 | comp;
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public @Nullable JClassSymbol getEnclosingClass() {
        return null;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isRecord() {
        return false;
    }

    @Override
    public boolean isLocalClass() {
        return false;
    }

    @Override
    public boolean isAnonymousClass() {
        return false;
    }

    public String toString() {
        return SymbolToStrings.SHARED.toString(this);
    }
}

