/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstClassSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstLocalVarSym;
import net.sourceforge.pmd.lang.java.symbols.internal.ast.AstUnnamedClassSym;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AstSymFactory {
    private final TypeSystem ts;
    private final JavaAstProcessor processor;

    AstSymFactory(JavaAstProcessor processor) {
        this.ts = processor.getTypeSystem();
        this.processor = processor;
    }

    JClassType recordSuperclass() {
        return (JClassType)this.ts.declaration(this.processor.findSymbolCannotFail("java.lang.Record"));
    }

    JClassType enumSuperclass(JClassSymbol enumT) {
        return (JClassType)this.ts.parameterise(this.processor.findSymbolCannotFail("java.lang.Enum"), CollectionUtil.listOf((Object)this.ts.declaration(enumT), (Object[])new JTypeMirror[0]));
    }

    JClassSymbol annotationSym() {
        return this.processor.findSymbolCannotFail("java.lang.annotation.Annotation");
    }

    JClassType annotationType() {
        return (JClassType)this.ts.declaration(this.annotationSym());
    }

    public TypeSystem types() {
        return this.ts;
    }

    void setLocalVarSymbol(ASTVariableId id) {
        assert (!id.isField() && !id.isEnumConstant()) : "Local var symbol is not appropriate for fields";
        assert (!id.isFormalParameter() || id.isLambdaParameter() || id.isExceptionBlockParameter()) : "Local var symbol is not appropriate for method parameters";
        new AstLocalVarSym(id, this);
    }

    JClassSymbol setClassSymbol(@Nullable JTypeParameterOwnerSymbol enclosing, ASTTypeDeclaration klass) {
        if (enclosing instanceof JClassSymbol && klass.isNested()) {
            JClassSymbol inner = ((JClassSymbol)enclosing).getDeclaredClass(klass.getSimpleName());
            assert (inner != null) : "Inner class symbol was not created for " + klass;
            return inner;
        }
        return new AstClassSym(klass, this, enclosing);
    }

    JClassSymbol setClassSymbol(@NonNull ASTCompilationUnit compilationUnit) {
        return new AstUnnamedClassSym(compilationUnit, this);
    }
}

