/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.util.CollectionUtil;

enum ReductionStep {
    EQ(InferenceVar.BoundKind.EQ){

        @Override
        JTypeMirror solve(InferenceVar uv, InferenceContext inferenceContext) {
            return this.filterBounds(uv, inferenceContext).get(0);
        }
    }
    ,
    LOWER(InferenceVar.BoundKind.LOWER){

        @Override
        JTypeMirror solve(InferenceVar uv, InferenceContext infCtx) {
            return infCtx.ts.lub(this.filterBounds(uv, infCtx));
        }
    }
    ,
    UPPER(InferenceVar.BoundKind.UPPER){

        @Override
        JTypeMirror solve(InferenceVar uv, InferenceContext infCtx) {
            return infCtx.ts.glb(this.filterBounds(uv, infCtx));
        }
    }
    ,
    CAPTURED(InferenceVar.BoundKind.UPPER){

        @Override
        public boolean accepts(InferenceVar t, InferenceContext inferenceContext) {
            return t.isCaptured() && inferenceContext.areAllGround(t.getBounds(InferenceVar.BoundKind.LOWER)) && inferenceContext.areAllGround(t.getBounds(InferenceVar.BoundKind.UPPER));
        }

        @Override
        JTypeMirror solve(InferenceVar uv, InferenceContext infCtx) {
            JTypeMirror upper = !UPPER.filterBounds(uv, infCtx).isEmpty() ? UPPER.solve(uv, infCtx) : infCtx.ts.OBJECT;
            JTypeMirror lower = !LOWER.filterBounds(uv, infCtx).isEmpty() ? LOWER.solve(uv, infCtx) : infCtx.ts.NULL_TYPE;
            return uv.getBaseVar().cloneWithBounds(lower, upper);
        }
    }
    ,
    FBOUND(InferenceVar.BoundKind.UPPER){

        @Override
        public boolean accepts(InferenceVar t, InferenceContext inferenceContext) {
            Set<JTypeMirror> ubounds = t.getBounds(InferenceVar.BoundKind.UPPER);
            Set<InferenceVar> freeVars = inferenceContext.freeVarsIn(ubounds);
            return CollectionUtil.asSingle(freeVars) == t;
        }

        @Override
        JTypeMirror solve(InferenceVar uv, InferenceContext infCtx) {
            return infCtx.ts.glb(TypeOps.erase(uv.getBounds(InferenceVar.BoundKind.UPPER)));
        }
    };

    static final List<List<ReductionStep>> WAVES;
    final InferenceVar.BoundKind kind;

    private ReductionStep(InferenceVar.BoundKind kind) {
        this.kind = kind;
    }

    abstract JTypeMirror solve(InferenceVar var1, InferenceContext var2);

    public boolean accepts(InferenceVar t, InferenceContext infCtx) {
        return !t.isCaptured() && !this.filterBounds(t, infCtx).isEmpty();
    }

    protected boolean acceptsBound(JTypeMirror bound, InferenceContext infCtx) {
        return infCtx.isGround(bound) && bound != infCtx.ts.NULL_TYPE;
    }

    List<JTypeMirror> filterBounds(InferenceVar ivar, InferenceContext infCtx) {
        ArrayList<JTypeMirror> res = new ArrayList<JTypeMirror>();
        for (JTypeMirror bound : ivar.getBounds(this.kind)) {
            if (!this.acceptsBound(bound, infCtx)) continue;
            res.add(bound);
        }
        return res;
    }

    static {
        WAVES = CollectionUtil.listOf((Object)CollectionUtil.listOf((Object)((Object)EQ), (Object[])new ReductionStep[]{LOWER, UPPER, CAPTURED}), (Object[])new List[]{CollectionUtil.listOf((Object)((Object)EQ), (Object[])new ReductionStep[]{LOWER, FBOUND, UPPER, CAPTURED})});
    }
}

