/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccTokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.JjtreeParserAdapter;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaParserImpl;
import net.sourceforge.pmd.lang.java.ast.JavaTokenDocumentBehavior;
import net.sourceforge.pmd.lang.java.ast.internal.LanguageLevelChecker;
import net.sourceforge.pmd.lang.java.ast.internal.ReportingStrategy;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProcessor;
import net.sourceforge.pmd.lang.java.internal.JavaLanguageProperties;

public class JavaParser
extends JjtreeParserAdapter<ASTCompilationUnit> {
    private final String suppressMarker;
    private final JavaLanguageProcessor javaProcessor;
    private final boolean postProcess;

    public JavaParser(String suppressMarker, JavaLanguageProcessor javaProcessor, boolean postProcess) {
        this.suppressMarker = suppressMarker;
        this.javaProcessor = javaProcessor;
        this.postProcess = postProcess;
    }

    protected JavaccTokenDocument.TokenDocumentBehavior tokenBehavior() {
        return JavaTokenDocumentBehavior.INSTANCE;
    }

    protected ASTCompilationUnit parseImpl(CharStream cs, Parser.ParserTask task) throws ParseException {
        LanguageVersion version = task.getLanguageVersion();
        int jdkVersion = JavaLanguageProperties.getInternalJdkVersion(version);
        boolean preview = JavaLanguageProperties.isPreviewEnabled(version);
        JavaParserImpl parser = new JavaParserImpl(cs);
        parser.setSuppressMarker(this.suppressMarker);
        parser.setJdkVersion(jdkVersion);
        parser.setPreview(preview);
        ASTCompilationUnit root = parser.CompilationUnit();
        root.setAstInfo((AstInfo<ASTCompilationUnit>)new AstInfo(task, (RootNode)root).withSuppressMap(parser.getSuppressMap()));
        LanguageLevelChecker<Void> levelChecker = new LanguageLevelChecker<Void>(jdkVersion, preview, ReportingStrategy.reporterThatThrows());
        levelChecker.check(root);
        if (this.postProcess) {
            JavaAstProcessor.process(this.javaProcessor, task.getReporter(), root);
        }
        return root;
    }
}

