/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class UnusedFormalParameterRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> CHECKALL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkAll").desc("Check all methods, including non-private ones")).defaultValue((Object)false)).build();

    public UnusedFormalParameterRule() {
        super(ASTConstructorDeclaration.class, ASTMethodDeclaration.class);
        this.definePropertyDescriptor(CHECKALL_DESCRIPTOR);
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.check(node, data);
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.getVisibility() != ModifierOwner.Visibility.V_PRIVATE && !((Boolean)this.getProperty(CHECKALL_DESCRIPTOR)).booleanValue()) {
            return data;
        }
        if (!(node.getBody() == null || node.hasModifiers(JModifier.DEFAULT, new JModifier[0]) || JavaRuleUtil.isSerializationReadObject(node) || node.isOverridden())) {
            this.check(node, data);
        }
        return data;
    }

    private void check(ASTExecutableDeclaration node, Object data) {
        for (ASTFormalParameter formal : node.getFormalParameters()) {
            ASTVariableId varId = formal.getVarId();
            if (!JavaAstUtils.isNeverUsed(varId) || JavaRuleUtil.isExplicitUnusedVarName(varId.getName())) continue;
            this.asCtx(data).addViolation((Node)varId, new Object[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", varId.getName()});
        }
    }
}

