/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.MapFunction;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class Substitution
extends MapFunction<SubstVar, JTypeMirror> {
    public static final Substitution EMPTY = new Substitution(Collections.emptyMap());

    Substitution(Map<@NonNull SubstVar, @NonNull JTypeMirror> map) {
        super(map);
    }

    public static boolean isEmptySubst(Function<?, ?> m) {
        return m == EMPTY || m instanceof MapFunction && ((MapFunction)m).isEmpty();
    }

    @Override
    public @NonNull JTypeMirror apply(@NonNull SubstVar var) {
        return this.getMap().getOrDefault(var, var);
    }

    public Substitution andThen(Substitution other) {
        AssertionUtil.requireParamNotNull((String)"subst", (Object)other);
        if (other.isEmpty()) {
            return this;
        }
        HashMap<SubstVar, JTypeMirror> newSubst = new HashMap<SubstVar, JTypeMirror>(other.getMap());
        for (Map.Entry entry : this.getMap().entrySet()) {
            JTypeVisitable substed = ((JTypeMirror)entry.getValue()).subst((Function)other);
            newSubst.put((SubstVar)entry.getKey(), (JTypeMirror)substed);
        }
        return new Substitution((Map<SubstVar, JTypeMirror>)newSubst);
    }

    public Substitution plus(SubstVar from, JTypeMirror to) {
        return new Substitution(CollectionUtil.plus(this.getMap(), (Object)from, (Object)to));
    }

    public static Substitution mapping(List<? extends SubstVar> from, List<? extends JTypeMirror> to) {
        AssertionUtil.requireParamNotNull((String)"from", from);
        AssertionUtil.requireParamNotNull((String)"to", to);
        if (from.isEmpty()) {
            return EMPTY;
        }
        return new Substitution(CollectionUtil.zip(from, to));
    }

    public static Substitution erasing(List<? extends JTypeVar> tparams) {
        if (tparams.isEmpty()) {
            return EMPTY;
        }
        return new Substitution(CollectionUtil.associateWith(tparams, JTypeMirror::getErasure));
    }
}

