/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.codegen.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.tool.codegen.WSDL2JavaGenerator;
import org.apache.axis2.tool.codegen.eclipse.plugin.CodegenWizardPlugin;
import org.apache.axis2.tool.codegen.eclipse.ui.AbstractWizardPage;
import org.apache.axis2.tool.codegen.eclipse.ui.JavaSourceSelectionPage;
import org.apache.axis2.tool.codegen.eclipse.ui.JavaWSDLOptionsPage;
import org.apache.axis2.tool.codegen.eclipse.ui.JavaWSDLOutputLocationPage;
import org.apache.axis2.tool.codegen.eclipse.ui.OptionsPage;
import org.apache.axis2.tool.codegen.eclipse.ui.OutputPage;
import org.apache.axis2.tool.codegen.eclipse.ui.ToolSelectionPage;
import org.apache.axis2.tool.codegen.eclipse.ui.WSDLFileSelectionPage;
import org.apache.axis2.tool.codegen.eclipse.util.WSDLPropertyReader;
import org.apache.axis2.tool.core.JarFileWriter;
import org.apache.axis2.tool.core.SrcCompiler;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;
import org.apache.ws.java2wsdl.Java2WSDLCodegenEngine;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class CodeGenWizard
extends Wizard
implements INewWizard,
Java2WSDLConstants {
    private ToolSelectionPage toolSelectionPage;
    private WSDLFileSelectionPage wsdlSelectionPage;
    private OptionsPage optionsPage;
    private OutputPage outputPage;
    private JavaWSDLOptionsPage java2wsdlOptionsPage;
    private JavaSourceSelectionPage javaSourceSelectionPage;
    private JavaWSDLOutputLocationPage java2wsdlOutputLocationPage;
    private int selectedWizardType = 1;
    private int selectedCodegenOptionType = 11;

    public CodeGenWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(CodegenWizardPlugin.getResourceString("general.name"));
    }

    public void addPages() {
        this.toolSelectionPage = new ToolSelectionPage();
        this.addPage((IWizardPage)this.toolSelectionPage);
        this.wsdlSelectionPage = new WSDLFileSelectionPage();
        this.addPage((IWizardPage)this.wsdlSelectionPage);
        this.optionsPage = new OptionsPage();
        this.addPage((IWizardPage)this.optionsPage);
        this.outputPage = new OutputPage();
        this.addPage((IWizardPage)this.outputPage);
        this.javaSourceSelectionPage = new JavaSourceSelectionPage();
        this.addPage((IWizardPage)this.javaSourceSelectionPage);
        this.java2wsdlOptionsPage = new JavaWSDLOptionsPage();
        this.addPage((IWizardPage)this.java2wsdlOptionsPage);
        this.java2wsdlOutputLocationPage = new JavaWSDLOutputLocationPage();
        this.addPage((IWizardPage)this.java2wsdlOutputLocationPage);
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        AbstractWizardPage wizardPage = null;
        for (int i = 0; i < pages.length; ++i) {
            wizardPage = (AbstractWizardPage)pages[i];
            if (wizardPage.getPageType() != this.selectedWizardType || wizardPage.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractWizardPage currentPage = (AbstractWizardPage)page;
        AbstractWizardPage pageout = (AbstractWizardPage)super.getNextPage(page);
        while (pageout != null && this.selectedWizardType != pageout.getPageType()) {
            AbstractWizardPage temp = pageout;
            pageout = (AbstractWizardPage)super.getNextPage((IWizardPage)currentPage);
            currentPage = temp;
        }
        return pageout;
    }

    public boolean performFinish() {
        try {
            switch (this.selectedWizardType) {
                case 1: {
                    this.doFinishWSDL2Java();
                    break;
                }
                case 2: {
                    this.doFinishJava2WSDL();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new RuntimeException(CodegenWizardPlugin.getResourceString("general.invalid.state"));
                }
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)CodegenWizardPlugin.getResourceString("general.Error"), (String)(CodegenWizardPlugin.getResourceString("general.Error.prefix") + e.getMessage()));
            return false;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)CodegenWizardPlugin.getResourceString("general.name"), (String)CodegenWizardPlugin.getResourceString("wizard.success"));
        return true;
    }

    private void doFinishWSDL2Java() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(CodegenWizardPlugin.getResourceString("generator.generating"), 3);
                try {
                    boolean isServiceXML;
                    boolean isServerside;
                    WSDL2JavaGenerator generator = new WSDL2JavaGenerator();
                    monitor.subTask(CodegenWizardPlugin.getResourceString("generator.readingWOM"));
                    AxisService service = generator.getAxisService(CodeGenWizard.this.wsdlSelectionPage.getFileName());
                    monitor.worked(1);
                    boolean isGenerateServerSideInterface = false;
                    if (CodeGenWizard.this.optionsPage.getGenerateAll()) {
                        isServerside = true;
                        isServiceXML = true;
                        isGenerateServerSideInterface = true;
                    } else {
                        isServerside = CodeGenWizard.this.optionsPage.isServerside();
                        isServiceXML = CodeGenWizard.this.optionsPage.isServerXML();
                        isGenerateServerSideInterface = CodeGenWizard.this.optionsPage.getGenerateServerSideInterface();
                    }
                    Map optionsMap = generator.fillOptionMap(CodeGenWizard.this.optionsPage.isAsyncOnlyOn(), CodeGenWizard.this.optionsPage.isSyncOnlyOn(), isServerside, isServiceXML, CodeGenWizard.this.optionsPage.isGenerateTestCase(), CodeGenWizard.this.optionsPage.getGenerateAll(), CodeGenWizard.this.optionsPage.getServiceName(), CodeGenWizard.this.optionsPage.getPortName(), CodeGenWizard.this.optionsPage.getDatabinderName(), CodeGenWizard.this.wsdlSelectionPage.getFileName(), CodeGenWizard.this.optionsPage.getPackageName(), CodeGenWizard.this.optionsPage.getSelectedLanguage(), CodeGenWizard.this.outputPage.getOutputLocation(), CodeGenWizard.this.optionsPage.getNs2PkgMapping(), isGenerateServerSideInterface, CodeGenWizard.this.optionsPage.getAdvanceOptions());
                    CodeGenConfiguration codegenConfig = new CodeGenConfiguration(optionsMap);
                    codegenConfig.addAxisService(service);
                    WSDLPropertyReader reader = new WSDLPropertyReader();
                    reader.readWSDL(CodeGenWizard.this.wsdlSelectionPage.getFileName());
                    Definition wsdlDefinition = reader.getWsdlDefinition();
                    codegenConfig.setWsdlDefinition(wsdlDefinition);
                    codegenConfig.setBaseURI(generator.getBaseUri(CodeGenWizard.this.wsdlSelectionPage.getFileName()));
                    monitor.worked(1);
                    monitor.subTask(CodegenWizardPlugin.getResourceString("generator.generating"));
                    new CodeGenerationEngine(codegenConfig).generate();
                    if (CodeGenWizard.this.outputPage.getAxis2PluginLibCopyCheckBoxSelection()) {
                        String eclipseHome = System.getProperty("user.dir");
                        String pluginLibLocation = eclipseHome + File.separator + "plugins" + File.separator + "Axis2_Codegen_Wizard_1.3.0" + File.separator + "lib";
                        CodeGenWizard.this.addLibsToProjectLib(pluginLibLocation, CodeGenWizard.this.outputPage.getOutputLocation());
                    }
                    if (CodeGenWizard.this.outputPage.getAxisLibCopyCheckBoxSelection() && CodeGenWizard.this.outputPage.oktoLoadLibs()) {
                        String libDirectory = CodeGenWizard.this.outputPage.getAxisJarsLocation();
                        CodeGenWizard.this.addLibsToProjectLib(libDirectory, CodeGenWizard.this.outputPage.getOutputLocation());
                    }
                    if (CodeGenWizard.this.outputPage.getCreateJarCheckBoxSelection()) {
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        String tempCodegenLocation = workspace.getRoot().getLocation().toString() + File.separator + "codegen";
                        String tempProjectSrcLocation = tempCodegenLocation + File.separator + "codegen_temp_src_" + System.currentTimeMillis();
                        String tempProjectClassLocation = tempCodegenLocation + File.separator + "codegen_temp_class_" + System.currentTimeMillis();
                        File tempCodegenFile = new File(tempCodegenLocation);
                        File tempSrcFile = new File(tempProjectSrcLocation);
                        File tempClassFile = new File(tempProjectClassLocation);
                        tempCodegenFile.mkdir();
                        tempSrcFile.mkdir();
                        tempClassFile.mkdir();
                        CodeGenWizard.this.copyDirectory(new File(CodeGenWizard.this.outputPage.getOutputLocation()), tempSrcFile);
                        SrcCompiler srcCompileTool = new SrcCompiler();
                        srcCompileTool.compileSource(tempClassFile, tempProjectSrcLocation);
                        String projectLib = CodeGenWizard.this.outputPage.getOutputLocation() + File.separator + "lib";
                        JarFileWriter jarFileWriter = new JarFileWriter();
                        String jarFileName = "CodegenResults.jar";
                        if (!CodeGenWizard.this.outputPage.getJarFilename().equals("")) {
                            jarFileName = CodeGenWizard.this.outputPage.getJarFilename();
                        }
                        CodeGenWizard.this.outputPage.setJarFileName(jarFileName);
                        jarFileWriter.writeJarFile(new File(projectLib), jarFileName, tempClassFile);
                        CodeGenWizard.this.deleteDir(tempCodegenFile);
                    }
                    monitor.worked(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new InterruptedException(e.getMessage());
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
            throw new RuntimeException(e1);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void doFinishJava2WSDL() throws Exception {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(CodegenWizardPlugin.getResourceString("generator.generating"), 3);
                try {
                    monitor.worked(1);
                    HashMap<String, Java2WSDLCommandLineOption> optionsMap = new HashMap<String, Java2WSDLCommandLineOption>();
                    Java2WSDLCommandLineOption option = new Java2WSDLCommandLineOption("cn", new String[]{CodeGenWizard.this.javaSourceSelectionPage.getClassName()});
                    optionsMap.put("cn", option);
                    option = new Java2WSDLCommandLineOption("cp", CodeGenWizard.this.javaSourceSelectionPage.getClassPathList());
                    optionsMap.put("cp", option);
                    option = new Java2WSDLCommandLineOption("tn", new String[]{CodeGenWizard.this.java2wsdlOptionsPage.getTargetNamespace()});
                    optionsMap.put("tn", option);
                    option = new Java2WSDLCommandLineOption("tp", new String[]{CodeGenWizard.this.java2wsdlOptionsPage.getTargetNamespacePrefix()});
                    optionsMap.put("tp", option);
                    option = new Java2WSDLCommandLineOption("stn", new String[]{CodeGenWizard.this.java2wsdlOptionsPage.getSchemaTargetNamespace()});
                    optionsMap.put("stn", option);
                    option = new Java2WSDLCommandLineOption("sn", new String[]{CodeGenWizard.this.java2wsdlOptionsPage.getServiceName()});
                    optionsMap.put("sn", option);
                    option = new Java2WSDLCommandLineOption("stp", new String[]{CodeGenWizard.this.java2wsdlOptionsPage.getSchemaTargetNamespacePrefix()});
                    optionsMap.put("stp", option);
                    option = new Java2WSDLCommandLineOption("o", new String[]{CodeGenWizard.this.java2wsdlOutputLocationPage.getOutputLocation()});
                    optionsMap.put("o", option);
                    option = new Java2WSDLCommandLineOption("of", new String[]{CodeGenWizard.this.java2wsdlOutputLocationPage.getOutputWSDLName()});
                    optionsMap.put("of", option);
                    monitor.worked(1);
                    new Java2WSDLCodegenEngine(optionsMap).generate();
                    monitor.worked(1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e1) {
            throw new RuntimeException(e1);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(CodegenWizardPlugin.getResourceString("general.useraborted.state"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public int getSelectedWizardType() {
        return this.selectedWizardType;
    }

    public void setSelectedWizardType(int selectedWizardType) {
        this.selectedWizardType = selectedWizardType;
    }

    public int getSelectedCodegenOptionType() {
        return this.selectedCodegenOptionType;
    }

    public void setSelectedCodegenOptionType(int selectedCodegenOptionType) {
        this.selectedCodegenOptionType = selectedCodegenOptionType;
    }

    public String getWSDLname() {
        return this.wsdlSelectionPage.getFileName();
    }

    public void populateOptions() {
        this.optionsPage.populateParamsFromWSDL();
    }

    public void setDefaultNamespaces(String fullyQualifiedClassName) {
        this.java2wsdlOptionsPage.setNamespaceDefaults(fullyQualifiedClassName);
    }

    private void addLibsToProjectLib(String libDirectory, String outputLocation) {
        String newOutputLocation = outputLocation + File.separator + "lib";
        boolean success = new File(newOutputLocation).mkdir();
        if (!success) {
            // empty if block
        }
        try {
            this.copyDirectory(new File(libDirectory), new File(newOutputLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    private void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

