/*
 * Decompiled with CFR 0.152.
 */
package org.api4.java.algorithm.events.serializable;

import java.util.Map;
import java.util.NoSuchElementException;
import org.api4.java.algorithm.events.AlgorithmEvent;
import org.api4.java.algorithm.events.serializable.PropertyProcessedAlgorithmEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyProcessedAlgorithmEvent
implements PropertyProcessedAlgorithmEvent {
    private static final long serialVersionUID = -6645533957593455739L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPropertyProcessedAlgorithmEvent.class);
    private String eventName;
    private String completeOriginalEventName;
    private Map<String, Object> properties;
    private transient AlgorithmEvent originalAlgorithmEvent;
    private long timestampOfEvent;

    private DefaultPropertyProcessedAlgorithmEvent() {
    }

    public DefaultPropertyProcessedAlgorithmEvent(String eventName, String completeOriginalEventName, Map<String, Object> properties, long timestampOfEvent) {
        this.eventName = eventName;
        this.completeOriginalEventName = completeOriginalEventName;
        this.properties = properties;
        this.timestampOfEvent = timestampOfEvent;
    }

    public DefaultPropertyProcessedAlgorithmEvent(String eventName, Map<String, Object> properties, AlgorithmEvent originalAlgorithmEvent, long timestampOfEvent) {
        this(eventName, originalAlgorithmEvent.getClass().getName(), properties, timestampOfEvent);
        this.originalAlgorithmEvent = originalAlgorithmEvent;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public String getCompleteOriginalEventName() {
        return this.completeOriginalEventName;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public <N> N getProperty(String propertyName, Class<N> expectedClassToBeReturned) {
        Object property = this.properties.get(propertyName);
        if (property == null) {
            throw new NoSuchElementException("No property with name \"" + propertyName + "\" present.");
        }
        if (!expectedClassToBeReturned.isInstance(property)) {
            throw new ClassCastException("Property with name \"" + propertyName + "\" is not of type: " + expectedClassToBeReturned.getName());
        }
        return (N)property;
    }

    @Override
    public AlgorithmEvent getOriginalEvent() {
        return this.originalAlgorithmEvent;
    }

    @Override
    public boolean correspondsToEventOfClass(Class<? extends AlgorithmEvent> eventClass) {
        return eventClass.getSimpleName().equals(this.getEventName()) || eventClass.isAssignableFrom(this.getClassOfOriginalEvent());
    }

    @Override
    public long getTimestampOfEvent() {
        return this.timestampOfEvent;
    }

    private Class<?> getClassOfOriginalEvent() {
        try {
            return Class.forName(this.getCompleteOriginalEventName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn("Cannot find class with name\u00a0{}.", (Object)this.getCompleteOriginalEventName(), (Object)e);
            return null;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.completeOriginalEventName == null ? 0 : this.completeOriginalEventName.hashCode());
        result = 31 * result + (this.eventName == null ? 0 : this.eventName.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (int)(this.timestampOfEvent ^ this.timestampOfEvent >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPropertyProcessedAlgorithmEvent other = (DefaultPropertyProcessedAlgorithmEvent)obj;
        if (this.completeOriginalEventName == null ? other.completeOriginalEventName != null : !this.completeOriginalEventName.equals(other.completeOriginalEventName)) {
            return false;
        }
        if (this.eventName == null ? other.eventName != null : !this.eventName.equals(other.eventName)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.timestampOfEvent == other.timestampOfEvent;
    }

    public String toString() {
        return "DefaultPropertyProcessedAlgorithmEvent [eventName=" + this.eventName + ", completeOriginalEventName=" + this.completeOriginalEventName + ", properties=" + this.properties + ", timestampOfEvent=" + this.timestampOfEvent + "]";
    }
}

