/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.asteriskjava.fastagi.DefaultAgiServer;

public class Cli {
    private void parseOptions(String[] args) throws Exception {
        if (args.length == 0) {
            this.startAgiServer();
            return;
        }
        String arg = args[0];
        if ("-h".equals(arg) || "-help".equals(arg)) {
            this.showHelp();
        } else if ("-v".equals(arg) || "-version".equals(arg)) {
            this.showVersion();
        } else if ("-a".equals(arg) || "-agi".equals(arg)) {
            if (args.length >= 2) {
                Integer port = null;
                try {
                    port = new Integer(args[1]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid port '" + args[1] + "'. Port must be a number.");
                    this.exit(1);
                }
                this.startAgiServer(port);
            }
        } else {
            this.showHelp();
        }
    }

    private void showHelp() {
        this.showVersion();
        System.err.println();
        System.err.println("-a, -agi [port]\n\tStarts a FastAGI server");
        System.err.println("-h, -help\n\tDisplays the available options\n");
        System.err.println("-v, -version\n\tDisplays the version of Asterisk-Java\n");
    }

    private void showVersion() {
        System.out.println("Asterisk-Java " + this.getVersion());
    }

    private String getVersion() {
        String version = "<unknown>";
        InputStream is = this.getClass().getResourceAsStream("/META-INF/maven/org.asteriskjava/asterisk-java/pom.properties");
        if (is == null) {
            return version;
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (IOException e) {
            return version;
        }
        version = properties.getProperty("version", version);
        return version;
    }

    private void startAgiServer() throws IOException {
        this.startAgiServer(null);
    }

    private void startAgiServer(Integer port) throws IOException {
        DefaultAgiServer server = new DefaultAgiServer();
        if (port != null) {
            server.setPort(port);
        }
        server.startup();
    }

    private void exit(int code) {
        System.exit(code);
    }

    public static void main(String[] args) throws Exception {
        new Cli().parseOptions(args);
    }
}

