/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import org.asteriskjava.live.AgentState;
import org.asteriskjava.live.AsteriskAgent;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskServerImpl;

public class AsteriskAgentImpl
extends AbstractLiveObject
implements AsteriskAgent {
    public String name;
    public String agentId;
    public AgentState state;

    AsteriskAgentImpl(AsteriskServerImpl server, String name, String agentId, AgentState state) {
        super(server);
        if (server == null || name == null || agentId == null) {
            throw new IllegalArgumentException("Parameters passed to AsteriskAgentImpl() must not be null.");
        }
        this.name = name;
        this.agentId = agentId;
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public AgentState getState() {
        return this.state;
    }

    synchronized void updateState(AgentState state) {
        AgentState oldState = this.state;
        this.state = state;
        this.firePropertyChange("state", (Object)oldState, (Object)this.state);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AsteriskAgent[");
        sb.append("agentId='").append(this.getAgentId()).append("',");
        sb.append("name='").append(this.getName()).append("',");
        sb.append("state=").append((Object)this.getState()).append(",");
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }
}

